/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.jetty9;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.fediz.core.ClaimCollection;
import org.apache.cxf.fediz.core.FedizPrincipal;
import org.apache.cxf.fediz.core.processor.FedizResponse;
import org.w3c.dom.Element;

public class FederationUserPrincipal
implements FedizPrincipal {
    private String name;
    private ClaimCollection claims;
    private FedizResponse response;
    private List<String> roles = Collections.emptyList();

    public FederationUserPrincipal(String name, FedizResponse response) {
        this.name = name;
        this.response = response;
        this.claims = new ClaimCollection((Collection)response.getClaims());
        if (response.getRoles() != null) {
            this.roles = response.getRoles();
        }
    }

    public String getName() {
        return this.name;
    }

    public ClaimCollection getClaims() {
        return this.claims;
    }

    FedizResponse getFedizResponse() {
        return this.response;
    }

    public Element getLoginToken() {
        return this.response.getToken();
    }

    public List<String> getRoleClaims() {
        return Collections.unmodifiableList(this.roles);
    }
}

