/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring.authentication;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.cxf.fediz.core.ClaimCollection;
import org.apache.cxf.fediz.core.processor.FedizResponse;
import org.apache.cxf.fediz.spring.FederationUser;
import org.apache.cxf.fediz.spring.authentication.AbstractFederationUserDetailsService;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class GrantedAuthoritiesUserDetailsFederationService
extends AbstractFederationUserDetailsService {
    private boolean convertToUpperCase = true;

    @Override
    protected UserDetails loadUserDetails(FedizResponse response) {
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        if (response.getRoles() != null) {
            for (String role : response.getRoles()) {
                grantedAuthorities.add(new SimpleGrantedAuthority("ROLE_" + (this.convertToUpperCase ? role.toUpperCase() : role)));
            }
        }
        return new FederationUser(response.getUsername(), "N/A", grantedAuthorities, new ClaimCollection((Collection)response.getClaims()));
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }
}

