/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.managers;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.endpoint.EndpointResolver;
import org.apache.cxf.endpoint.EndpointResolverRegistry;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

@NoJSR250Annotations
public class EndpointResolverRegistryImpl
implements EndpointResolverRegistry {
    private Bus bus;
    private List<EndpointResolver> resolvers = new CopyOnWriteArrayList<EndpointResolver>();

    public EndpointResolverRegistryImpl() {
    }

    public EndpointResolverRegistryImpl(Bus b) {
        this.setBus(b);
    }

    public final void setBus(Bus b) {
        this.bus = b;
        if (this.bus != null) {
            this.bus.setExtension(this, EndpointResolverRegistry.class);
        }
    }

    @Override
    public synchronized void register(EndpointResolver resolver) {
        this.resolvers.add(resolver);
    }

    @Override
    public synchronized void unregister(EndpointResolver resolver) {
        this.resolvers.remove(resolver);
    }

    @Override
    public synchronized EndpointReferenceType resolve(EndpointReferenceType logical) {
        EndpointResolver resolver;
        EndpointReferenceType physical = null;
        Iterator<EndpointResolver> iterator = this.resolvers.iterator();
        while (iterator.hasNext() && (physical = (resolver = iterator.next()).resolve(logical)) == null) {
        }
        return physical;
    }

    @Override
    public EndpointReferenceType renew(EndpointReferenceType logical, EndpointReferenceType physical) {
        EndpointResolver resolver;
        EndpointReferenceType fresh = null;
        Iterator<EndpointResolver> iterator = this.resolvers.iterator();
        while (iterator.hasNext() && (fresh = (resolver = iterator.next()).renew(logical, physical)) == null) {
        }
        return fresh;
    }

    @Override
    public EndpointReferenceType mint(QName serviceName) {
        EndpointResolver resolver;
        EndpointReferenceType logical = null;
        Iterator<EndpointResolver> iterator = this.resolvers.iterator();
        while (iterator.hasNext() && (logical = (resolver = iterator.next()).mint(serviceName)) == null) {
        }
        return logical;
    }

    @Override
    public EndpointReferenceType mint(EndpointReferenceType physical) {
        EndpointResolver resolver;
        EndpointReferenceType logical = null;
        Iterator<EndpointResolver> iterator = this.resolvers.iterator();
        while (iterator.hasNext() && (logical = (resolver = iterator.next()).mint(physical)) == null) {
        }
        return logical;
    }

    protected List<EndpointResolver> getResolvers() {
        return this.resolvers;
    }
}

