/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsn.services;

import jakarta.jms.ConnectionFactory;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.cxf.wsn.AbstractCreatePullPoint;
import org.apache.cxf.wsn.AbstractNotificationBroker;
import org.apache.cxf.wsn.services.JaxwsCreatePullPoint;
import org.apache.cxf.wsn.services.JaxwsNotificationBroker;

public class Service {
    private static final String EMBEDED_BROKER = "vm:(broker:(tcp://localhost:6000)?persistent=false)";
    String rootURL = "http://0.0.0.0:9000/wsn";
    String activeMqUrl = "vm:(broker:(tcp://localhost:6000)?persistent=false)";
    String userName;
    String password;
    boolean jmxEnable = true;
    AbstractCreatePullPoint createPullPointServer;
    AbstractNotificationBroker notificationBrokerServer;

    public Service(String[] args) {
        for (int x = 0; x < args.length; ++x) {
            if ("-brokerUrl".equals(args[x])) {
                this.activeMqUrl = args[++x];
                continue;
            }
            if ("-userName".equals(args[x])) {
                this.userName = args[++x];
                continue;
            }
            if ("-password".equals(args[x])) {
                this.password = args[++x];
                continue;
            }
            if ("-rootUrl".equals(args[x])) {
                this.rootURL = args[++x];
                continue;
            }
            if (!"-jmxEnable".equals(args[x])) continue;
            this.jmxEnable = Boolean.valueOf(args[++x]);
        }
    }

    public static void main(String[] args) throws Exception {
        new Service(args).start();
    }

    public void start() throws Exception {
        if (EMBEDED_BROKER.equalsIgnoreCase(this.activeMqUrl)) {
            ConfigurationImpl config = new ConfigurationImpl();
            config.addAcceptorConfiguration("vm", "vm://0");
            config.addAcceptorConfiguration("tcp", "tcp://localhost:6000");
            config.setPersistenceEnabled(false);
            config.setSecurityEnabled(false);
            EmbeddedActiveMQ server = new EmbeddedActiveMQ();
            server.setConfiguration((Configuration)config);
            server.start();
        }
        ActiveMQConnectionFactory activemq = new ActiveMQConnectionFactory(this.activeMqUrl, this.userName, this.password);
        this.notificationBrokerServer = new JaxwsNotificationBroker("WSNotificationBroker", (ConnectionFactory)activemq);
        this.notificationBrokerServer.setAddress(this.rootURL + "/NotificationBroker");
        this.notificationBrokerServer.init();
        this.createPullPointServer = new JaxwsCreatePullPoint("CreatePullPoint", (ConnectionFactory)activemq);
        this.createPullPointServer.setAddress(this.rootURL + "/CreatePullPoint");
        this.createPullPointServer.init();
        if (this.jmxEnable) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(this.notificationBrokerServer, this.notificationBrokerServer.getMBeanName());
            mbs.registerMBean(this.createPullPointServer, this.createPullPointServer.getMBeanName());
        }
    }
}

