/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.readers;

import org.apache.commons.jci.AbstractTestCase;
import org.apache.commons.jci.readers.FileResourceReader;
import org.apache.commons.jci.readers.MemoryResourceReader;
import org.apache.commons.jci.readers.ResourceReader;

public final class ResourceReaderTestCase
extends AbstractTestCase {
    public void testFileResourceReader() throws Exception {
        this.writeFile("test", "test");
        this.checkRead((ResourceReader)new FileResourceReader(this.directory));
    }

    public void testMemoryResourceReader() throws Exception {
        MemoryResourceReader reader = new MemoryResourceReader();
        reader.add("test", "test".getBytes());
        this.checkRead((ResourceReader)reader);
        reader.remove(null);
        ResourceReaderTestCase.assertTrue((boolean)reader.isAvailable("test"));
        reader.remove("test");
        ResourceReaderTestCase.assertFalse((boolean)reader.isAvailable("test"));
    }

    private void checkRead(ResourceReader reader) throws Exception {
        ResourceReaderTestCase.assertTrue((boolean)reader.isAvailable("test"));
        byte[] content = reader.getBytes("test");
        ResourceReaderTestCase.assertTrue((content != null ? 1 : 0) != 0);
        ResourceReaderTestCase.assertEquals((String)"test", (String)new String(content));
        ResourceReaderTestCase.assertFalse((boolean)reader.isAvailable("bla"));
        ResourceReaderTestCase.assertTrue((reader.getBytes("bla") == null ? 1 : 0) != 0);
    }
}

