/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.compilers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.jci.compilers.AbstractJavaCompiler;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.compilers.JaninoCompilationProblem;
import org.apache.commons.jci.compilers.JaninoJavaCompilerSettings;
import org.apache.commons.jci.compilers.JavaCompilerSettings;
import org.apache.commons.jci.problems.CompilationProblem;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.LocatedException;
import org.codehaus.commons.compiler.Location;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.Compiler;
import org.codehaus.janino.FilterWarningHandler;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.WarningHandler;
import org.codehaus.janino.util.StringPattern;
import org.codehaus.janino.util.resource.Resource;
import org.codehaus.janino.util.resource.ResourceCreator;
import org.codehaus.janino.util.resource.ResourceFinder;

public final class JaninoJavaCompiler
extends AbstractJavaCompiler {
    private final Log log = LogFactory.getLog(JaninoJavaCompiler.class);
    private final JaninoJavaCompilerSettings defaultSettings;

    public JaninoJavaCompiler() {
        this(new JaninoJavaCompilerSettings());
    }

    public JaninoJavaCompiler(JaninoJavaCompilerSettings pSettings) {
        this.defaultSettings = pSettings;
    }

    public CompilationResult compile(String[] pSourceNames, final ResourceReader pResourceReader, final ResourceStore pStore, ClassLoader pClassLoader, JavaCompilerSettings pSettings) {
        final ArrayList<JaninoCompilationProblem> problems = new ArrayList<JaninoCompilationProblem>();
        StringPattern[] pattern = StringPattern.PATTERNS_NONE;
        Compiler compiler = new Compiler(new ResourceFinder(){

            public Resource findResource(String pSourceName) {
                byte[] bytes = pResourceReader.getBytes(pSourceName);
                if (bytes == null) {
                    JaninoJavaCompiler.this.log.debug((Object)("failed to find source " + pSourceName));
                    return null;
                }
                JaninoJavaCompiler.this.log.debug((Object)("reading " + pSourceName + " (" + bytes.length + ")"));
                return new JciResource(pSourceName, bytes);
            }
        }, (IClassLoader)new ClassLoaderIClassLoader(pClassLoader), new ResourceFinder(){

            public Resource findResource(String pResourceName) {
                byte[] bytes = pStore.read(pResourceName);
                if (bytes == null) {
                    JaninoJavaCompiler.this.log.debug((Object)("failed to find " + pResourceName));
                    return null;
                }
                JaninoJavaCompiler.this.log.debug((Object)("reading " + pResourceName + " (" + bytes.length + ")"));
                return new JciResource(pResourceName, bytes);
            }
        }, new ResourceCreator(){

            public OutputStream createResource(String pResourceName) throws IOException {
                return new JciOutputStream(pResourceName, pStore);
            }

            public boolean deleteResource(String pResourceName) {
                JaninoJavaCompiler.this.log.debug((Object)("removing " + pResourceName));
                pStore.remove(pResourceName);
                return true;
            }
        }, pSettings.getSourceEncoding(), false, pSettings.isDebug(), pSettings.isDebug(), pSettings.isDebug(), (WarningHandler)new FilterWarningHandler(pattern, new WarningHandler(){

            public void handleWarning(String pHandle, String pMessage, Location pLocation) {
                JaninoCompilationProblem problem = new JaninoCompilationProblem(pLocation.getFileName(), pLocation, pMessage, false);
                if (JaninoJavaCompiler.this.problemHandler != null) {
                    JaninoJavaCompiler.this.problemHandler.handle((CompilationProblem)problem);
                }
                problems.add(problem);
            }
        }));
        compiler.setCompileErrorHandler(new UnitCompiler.ErrorHandler(){

            public void handleError(String pMessage, Location pLocation) throws CompileException {
                JaninoCompilationProblem problem = new JaninoCompilationProblem(pLocation.getFileName(), pLocation, pMessage, true);
                if (JaninoJavaCompiler.this.problemHandler != null) {
                    JaninoJavaCompiler.this.problemHandler.handle((CompilationProblem)problem);
                }
                problems.add(problem);
            }
        });
        Resource[] resources = new Resource[pSourceNames.length];
        for (int i = 0; i < pSourceNames.length; ++i) {
            this.log.debug((Object)("compiling " + pSourceNames[i]));
            byte[] source = pResourceReader.getBytes(pSourceNames[i]);
            resources[i] = new JciResource(pSourceNames[i], source);
        }
        try {
            compiler.compile(resources);
        }
        catch (LocatedException e) {
            problems.add(new JaninoCompilationProblem(e));
        }
        catch (IOException e) {
            this.log.error((Object)"this error should have been cought before", (Throwable)e);
        }
        CompilationProblem[] result = new CompilationProblem[problems.size()];
        problems.toArray(result);
        return new CompilationResult(result);
    }

    public JavaCompilerSettings createDefaultSettings() {
        return new JaninoJavaCompilerSettings(this.defaultSettings);
    }

    private static final class JciOutputStream
    extends ByteArrayOutputStream {
        private final String name;
        private final ResourceStore store;

        public JciOutputStream(String pName, ResourceStore pStore) {
            this.name = pName;
            this.store = pStore;
        }

        public void close() throws IOException {
            super.close();
            byte[] bytes = this.toByteArray();
            this.store.write(this.name, bytes);
        }
    }

    private static final class JciResource
    implements Resource {
        private final String name;
        private final byte[] bytes;

        public JciResource(String pName, byte[] pBytes) {
            this.name = pName;
            this.bytes = pBytes;
        }

        public String getFileName() {
            return this.name;
        }

        public long lastModified() {
            return 0L;
        }

        public InputStream open() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }
    }
}

