/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.webp;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.imaging.AbstractImagingTest;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.webp.WebPReadTest;

public abstract class AbstractWebPTest
extends AbstractImagingTest {
    private static final AbstractImagingTest.ImageFilter IMAGE_FILTER = AbstractWebPTest::isWebP;

    protected static List<File> getWebPImages() throws IOException, ImagingException {
        return AbstractWebPTest.getTestImages(IMAGE_FILTER);
    }

    protected static Stream<File> images() throws IOException {
        List<File> images = AbstractWebPTest.getWebPImages();
        File emptyWebP = new File(WebPReadTest.class.getResource("/images/webp/empty/empty-100x100.webp").getFile());
        File animationWebP = new File(WebPReadTest.class.getResource("/images/webp/animation/example.webp").getFile());
        File exifWebP = new File(WebPReadTest.class.getResource("/images/webp/exif/_DSC6099.webp").getFile());
        return Stream.concat(images.stream(), Stream.of(emptyWebP, animationWebP, exifWebP));
    }

    private static boolean isWebP(File file) throws IOException {
        ImageFormat format = Imaging.guessFormat((File)file);
        return format == ImageFormats.WEBP;
    }
}

