/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.io.File;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.common.BufferedImageFactory;
import org.apache.commons.imaging.examples.ImageReadExample;
import org.apache.commons.imaging.formats.png.PngImageParser;
import org.apache.commons.imaging.formats.png.PngImagingParameters;
import org.apache.commons.imaging.test.TestResources;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PngWithInvalidPngChunkSizeTest {
    @Test
    public void testPngWithInvalidNegativePngChunkSize() {
        File imageFile = TestResources.resourceToFile("/IMAGING-210/testfile.png");
        PngImagingParameters params = new PngImagingParameters();
        params.setBufferedImageFactory((BufferedImageFactory)new ImageReadExample.ManagedImageBufferedImageFactory());
        PngImageParser jpegImageParser = new PngImageParser();
        Assertions.assertThrows(ImagingException.class, () -> jpegImageParser.getBufferedImage(imageFile, (ImagingParameters)params));
    }

    @Test
    public void testPngWithInvalidPngChunkSize() {
        File imageFile = TestResources.resourceToFile("/IMAGING-211/testfile_2.png");
        PngImagingParameters params = new PngImagingParameters();
        params.setBufferedImageFactory((BufferedImageFactory)new ImageReadExample.ManagedImageBufferedImageFactory());
        PngImageParser jpegImageParser = new PngImageParser();
        Assertions.assertThrows(ImagingException.class, () -> jpegImageParser.getBufferedImage(imageFile, (ImagingParameters)params));
    }
}

