/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractMapEntryTest<K, V> {
    protected final String key = "name";
    protected final String value = "duke";

    public Map.Entry<K, V> makeKnownMapEntry() {
        return this.makeKnownMapEntry(null, null);
    }

    public Map.Entry<K, V> makeKnownMapEntry(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>(1);
        map.put(key, value);
        return map.entrySet().iterator().next();
    }

    public Map.Entry<K, V> makeMapEntry() {
        return this.makeMapEntry(null, null);
    }

    public abstract Map.Entry<K, V> makeMapEntry(K var1, V var2);

    @Test
    public void testAccessorsAndMutators() {
        Map.Entry<String, String> entry = this.makeMapEntry("name", "duke");
        Assertions.assertSame((Object)"name", (Object)entry.getKey());
        entry.setValue("duke");
        Assertions.assertSame((Object)"duke", (Object)entry.getValue());
        entry = this.makeMapEntry(null, null);
        Assertions.assertNull((Object)entry.getKey());
        entry.setValue(null);
        Assertions.assertNull((Object)entry.getValue());
    }

    public abstract void testConstructors();

    @Test
    public void testEqualsAndHashCode() {
        Map.Entry<String, String> e1 = this.makeMapEntry("name", "duke");
        Map.Entry<String, String> e2 = this.makeKnownMapEntry("name", "duke");
        Assertions.assertEquals(e1, e1);
        Assertions.assertEquals(e2, e1);
        Assertions.assertEquals(e1, e2);
        Assertions.assertEquals((int)e1.hashCode(), (int)e2.hashCode());
        e1 = this.makeMapEntry();
        e2 = this.makeKnownMapEntry();
        Assertions.assertEquals(e1, e1);
        Assertions.assertEquals(e2, e1);
        Assertions.assertEquals(e1, e2);
        Assertions.assertEquals((int)e1.hashCode(), (int)e2.hashCode());
    }

    @Test
    public void testSelfReferenceHandling() {
        Map.Entry entry = this.makeMapEntry();
        Assertions.assertThrows(IllegalArgumentException.class, () -> entry.setValue(entry));
        Assertions.assertTrue((entry.getKey() == null && entry.getValue() == null ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        Map.Entry<String, String> entry = this.makeMapEntry("name", "duke");
        Assertions.assertEquals((Object)entry.toString(), (Object)(entry.getKey() + "=" + entry.getValue()));
        entry = this.makeMapEntry();
        Assertions.assertEquals((Object)entry.toString(), (Object)(entry.getKey() + "=" + entry.getValue()));
    }
}

