/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import java.util.Comparator;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.AbstractPredicateTest;
import org.apache.commons.collections4.functors.ComparatorPredicate;
import org.junit.jupiter.api.Test;

public class ComparatorPredicateTest
extends AbstractPredicateTest {
    @Override
    protected Predicate<?> generatePredicate() {
        return ComparatorPredicate.comparatorPredicate((Object)10, new TestComparator());
    }

    @Test
    public void testCompareEquals() {
        Integer value = 10;
        Predicate p = ComparatorPredicate.comparatorPredicate((Object)value, new TestComparator());
        this.assertPredicateFalse(p, value - 1);
        this.assertPredicateTrue(p, Integer.valueOf(value));
        this.assertPredicateFalse(p, value + 1);
    }

    @Test
    public void testCompareGreater() {
        Integer value = 10;
        Predicate p = ComparatorPredicate.comparatorPredicate((Object)value, new TestComparator(), (ComparatorPredicate.Criterion)ComparatorPredicate.Criterion.GREATER);
        this.assertPredicateTrue(p, value - 1);
        this.assertPredicateFalse(p, Integer.valueOf(value));
        this.assertPredicateFalse(p, value + 1);
    }

    @Test
    public void testCompareGreaterOrEqual() {
        Integer value = 10;
        Predicate p = ComparatorPredicate.comparatorPredicate((Object)value, new TestComparator(), (ComparatorPredicate.Criterion)ComparatorPredicate.Criterion.GREATER_OR_EQUAL);
        this.assertPredicateTrue(p, value - 1);
        this.assertPredicateTrue(p, Integer.valueOf(value));
        this.assertPredicateFalse(p, value + 1);
    }

    @Test
    public void testCompareLess() {
        Integer value = 10;
        Predicate p = ComparatorPredicate.comparatorPredicate((Object)value, new TestComparator(), (ComparatorPredicate.Criterion)ComparatorPredicate.Criterion.LESS);
        this.assertPredicateFalse(p, value - 1);
        this.assertPredicateFalse(p, Integer.valueOf(value));
        this.assertPredicateTrue(p, value + 1);
    }

    @Test
    public void testCompareLessOrEqual() {
        Integer value = 10;
        Predicate p = ComparatorPredicate.comparatorPredicate((Object)value, new TestComparator(), (ComparatorPredicate.Criterion)ComparatorPredicate.Criterion.LESS_OR_EQUAL);
        this.assertPredicateFalse(p, value - 1);
        this.assertPredicateTrue(p, Integer.valueOf(value));
        this.assertPredicateTrue(p, value + 1);
    }

    private static final class TestComparator<T extends Comparable<T>>
    implements Comparator<T> {
        private TestComparator() {
        }

        @Override
        public int compare(T first, T second) {
            return first.compareTo(second);
        }
    }
}

