/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.Arrays;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.MultiSetUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.multiset.HashMultiSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MultiSetUtilsTest {
    private String[] fullArray;
    private MultiSet<String> multiSet;

    @BeforeEach
    public void setUp() {
        this.fullArray = new String[]{"a", "a", "b", "c", "d", "d", "d"};
        this.multiSet = new HashMultiSet(Arrays.asList(this.fullArray));
    }

    @Test
    public void testEmptyMultiSet() {
        MultiSet empty = MultiSetUtils.emptyMultiSet();
        Assertions.assertEquals((int)0, (int)empty.size());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> empty.add((Object)55), (String)"Empty multi set must be read-only");
    }

    @Test
    public void testPredicatedMultiSet() {
        Predicate predicate = object -> object.length() == 1;
        MultiSet predicated = MultiSetUtils.predicatedMultiSet(this.multiSet, (Predicate)predicate);
        Assertions.assertEquals((int)this.multiSet.size(), (int)predicated.size());
        Assertions.assertEquals((int)this.multiSet.getCount((Object)"a"), (int)predicated.getCount((Object)"a"));
        Assertions.assertThrows(NullPointerException.class, () -> MultiSetUtils.predicatedMultiSet(null, (Predicate)predicate), (String)"Expecting NPE");
        Assertions.assertThrows(NullPointerException.class, () -> MultiSetUtils.predicatedMultiSet(this.multiSet, null), (String)"Expecting NPE");
        Assertions.assertThrows(IllegalArgumentException.class, () -> MultiSetUtils.predicatedMultiSet(this.multiSet, object -> object.equals("a")), (String)"Predicate is violated for all elements not being 'a'");
    }

    @Test
    public void testSynchronizedMultiSet() {
        MultiSet synced = MultiSetUtils.synchronizedMultiSet(this.multiSet);
        Assertions.assertEquals(this.multiSet, (Object)synced);
        synced.add((Object)"a");
    }

    @Test
    public void testUnmodifiableMultiSet() {
        MultiSet unmodifiable = MultiSetUtils.unmodifiableMultiSet(this.multiSet);
        Assertions.assertEquals(this.multiSet, (Object)unmodifiable);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> unmodifiable.add((Object)"a"), (String)"Empty multi set must be read-only");
        Assertions.assertThrows(NullPointerException.class, () -> MultiSetUtils.unmodifiableMultiSet(null), (String)"Expecting NPE");
    }
}

