/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.collections4.EnumerationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EnumerationUtilsTest {
    public static final String TO_LIST_FIXTURE = "this is a test";

    @Test
    public void testAsIterableFor() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("zero");
        vector.addElement("one");
        Enumeration en = vector.elements();
        Iterator iterator = EnumerationUtils.asIterable(en).iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)"zero", iterator.next());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)"one", iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testAsIterableForNull() {
        Assertions.assertThrows(NullPointerException.class, () -> EnumerationUtils.asIterable((Enumeration)null).iterator().next());
    }

    @Test
    public void testGetFromEnumeration() throws Exception {
        Vector<String> vector = new Vector<String>();
        vector.addElement("zero");
        vector.addElement("one");
        Enumeration en = vector.elements();
        Assertions.assertEquals((Object)"zero", (Object)EnumerationUtils.get(en, (int)0));
        en = vector.elements();
        Assertions.assertEquals((Object)"one", (Object)EnumerationUtils.get(en, (int)1));
        Enumeration finalEn = en;
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> EnumerationUtils.get((Enumeration)finalEn, (int)3));
        Assertions.assertFalse((boolean)en.hasMoreElements());
    }

    @Test
    public void testToListWithHashtable() {
        Hashtable<String, Integer> expected = new Hashtable<String, Integer>();
        expected.put("one", 1);
        expected.put("two", 2);
        expected.put("three", 3);
        List actualEltList = EnumerationUtils.toList(expected.elements());
        Assertions.assertEquals((int)expected.size(), (int)actualEltList.size());
        Assertions.assertTrue((boolean)actualEltList.contains(1));
        Assertions.assertTrue((boolean)actualEltList.contains(2));
        Assertions.assertTrue((boolean)actualEltList.contains(3));
        ArrayList<Integer> expectedEltList = new ArrayList<Integer>();
        expectedEltList.add(1);
        expectedEltList.add(2);
        expectedEltList.add(3);
        Assertions.assertTrue((boolean)actualEltList.containsAll(expectedEltList));
        List actualKeyList = EnumerationUtils.toList(expected.keys());
        Assertions.assertEquals((int)expected.size(), (int)actualEltList.size());
        Assertions.assertTrue((boolean)actualKeyList.contains("one"));
        Assertions.assertTrue((boolean)actualKeyList.contains("two"));
        Assertions.assertTrue((boolean)actualKeyList.contains("three"));
        ArrayList<String> expectedKeyList = new ArrayList<String>();
        expectedKeyList.add("one");
        expectedKeyList.add("two");
        expectedKeyList.add("three");
        Assertions.assertTrue((boolean)actualKeyList.containsAll(expectedKeyList));
    }

    @Test
    public void testToListWithStringTokenizer() {
        ArrayList<String> expectedList1 = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(TO_LIST_FIXTURE);
        while (st.hasMoreTokens()) {
            expectedList1.add(st.nextToken());
        }
        ArrayList<String> expectedList2 = new ArrayList<String>();
        expectedList2.add("this");
        expectedList2.add("is");
        expectedList2.add("a");
        expectedList2.add("test");
        List actualList = EnumerationUtils.toList((StringTokenizer)new StringTokenizer(TO_LIST_FIXTURE));
        Assertions.assertEquals(expectedList1, expectedList2);
        Assertions.assertEquals(expectedList1, (Object)actualList);
        Assertions.assertEquals(expectedList2, (Object)actualList);
    }

    @Test
    public void testToSetWithHashtable() {
        Hashtable<String, Integer> expected = new Hashtable<String, Integer>();
        expected.put("one", 1);
        expected.put("two", 2);
        expected.put("three", 3);
        Set actualEltSet = EnumerationUtils.toSet(expected.elements());
        Assertions.assertEquals((int)expected.size(), (int)actualEltSet.size());
        Assertions.assertTrue((boolean)actualEltSet.contains(1));
        Assertions.assertTrue((boolean)actualEltSet.contains(2));
        Assertions.assertTrue((boolean)actualEltSet.contains(3));
        HashSet<Integer> expectedEltList = new HashSet<Integer>();
        expectedEltList.add(1);
        expectedEltList.add(2);
        expectedEltList.add(3);
        Assertions.assertTrue((boolean)actualEltSet.containsAll(expectedEltList));
        Set actualKeySet = EnumerationUtils.toSet(expected.keys());
        Assertions.assertEquals((int)expected.size(), (int)actualEltSet.size());
        Assertions.assertTrue((boolean)actualKeySet.contains("one"));
        Assertions.assertTrue((boolean)actualKeySet.contains("two"));
        Assertions.assertTrue((boolean)actualKeySet.contains("three"));
        HashSet<String> expectedKeySet = new HashSet<String>();
        expectedKeySet.add("one");
        expectedKeySet.add("two");
        expectedKeySet.add("three");
        Assertions.assertTrue((boolean)actualKeySet.containsAll(expectedKeySet));
    }
}

