/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql.filters;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.Range;
import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SSTableTimeRangeFilter
implements Serializable {
    public static final SSTableTimeRangeFilter ALL = new SSTableTimeRangeFilter((Range<Long>)Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(Long.MAX_VALUE)));
    private final Range<Long> timeRange;
    private final int hashcode;

    private SSTableTimeRangeFilter(Range<Long> timeRange) {
        this(timeRange, Objects.hash(timeRange));
    }

    private SSTableTimeRangeFilter(Range<Long> timeRange, int hashcode) {
        this.timeRange = timeRange;
        this.hashcode = hashcode;
    }

    @NotNull
    public Range<Long> range() {
        return this.timeRange;
    }

    public boolean overlaps(long startMicros, long endMicros) {
        Range sstableTimeRange = Range.closed((Comparable)Long.valueOf(startMicros), (Comparable)Long.valueOf(endMicros));
        return this.timeRange.isConnected(sstableTimeRange);
    }

    public String toString() {
        return String.format("TimeRangeFilter%s", this.timeRange.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SSTableTimeRangeFilter)) {
            return false;
        }
        SSTableTimeRangeFilter that = (SSTableTimeRangeFilter)o;
        return this.timeRange.equals(that.timeRange);
    }

    public int hashCode() {
        return this.hashcode;
    }

    @NotNull
    public static SSTableTimeRangeFilter create(long startMicros, long endMicros) {
        return new SSTableTimeRangeFilter((Range<Long>)Range.closed((Comparable)Long.valueOf(startMicros), (Comparable)Long.valueOf(endMicros)));
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<SSTableTimeRangeFilter> {
        public SSTableTimeRangeFilter read(Kryo kryo, Input in, Class<SSTableTimeRangeFilter> type) {
            return new SSTableTimeRangeFilter((Range<Long>)Range.closed((Comparable)Long.valueOf(in.readLong()), (Comparable)Long.valueOf(in.readLong())), in.readInt());
        }

        public void write(Kryo kryo, Output out, SSTableTimeRangeFilter object) {
            out.writeLong(((Long)object.timeRange.lowerEndpoint()).longValue());
            out.writeLong(((Long)object.timeRange.upperEndpoint()).longValue());
            out.writeInt(object.hashcode);
        }
    }
}

