/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.spark.data.CassandraTypes;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.utils.TableIdentifier;
import org.jetbrains.annotations.NotNull;

public class CqlTable
implements Serializable {
    private static final long serialVersionUID = 1018995207366817661L;
    private final ReplicationFactor replicationFactor;
    private final String keyspace;
    private final String table;
    private final String createStatement;
    private final List<CqlField> fields;
    private final Set<CqlField.CqlUdt> udts;
    private final Map<String, CqlField> fieldsMap;
    private final Set<String> columnsWithUdts;
    private final List<CqlField> partitionKeys;
    private final List<CqlField> clusteringKeys;
    private final List<CqlField> staticColumns;
    private final List<CqlField> valueColumns;
    private final transient Map<String, CqlField> columns;
    private final int indexCount;

    public CqlTable(@NotNull String keyspace, @NotNull String table, @NotNull String createStatement, @NotNull ReplicationFactor replicationFactor, @NotNull List<CqlField> fields) {
        this(keyspace, table, createStatement, replicationFactor, fields, Collections.emptySet(), 0);
    }

    public CqlTable(@NotNull String keyspace, @NotNull String table, @NotNull String createStatement, @NotNull ReplicationFactor replicationFactor, @NotNull List<CqlField> fields, @NotNull Set<CqlField.CqlUdt> udts, int indexCount) {
        this.keyspace = keyspace;
        this.table = table;
        this.createStatement = createStatement;
        this.replicationFactor = replicationFactor;
        this.fields = fields.stream().sorted().collect(Collectors.toList());
        this.fieldsMap = this.fields.stream().collect(Collectors.toMap(CqlField::name, Function.identity()));
        this.partitionKeys = this.fields.stream().filter(CqlField::isPartitionKey).sorted().collect(Collectors.toList());
        this.clusteringKeys = this.fields.stream().filter(CqlField::isClusteringColumn).sorted().collect(Collectors.toList());
        this.staticColumns = this.fields.stream().filter(CqlField::isStaticColumn).sorted().collect(Collectors.toList());
        this.valueColumns = this.fields.stream().filter(CqlField::isValueColumn).sorted().collect(Collectors.toList());
        this.udts = Collections.unmodifiableSet(udts);
        this.indexCount = indexCount;
        this.columns = new LinkedHashMap<String, CqlField>();
        for (CqlField column : this.partitionKeys) {
            this.columns.put(column.name(), column);
        }
        for (CqlField column : this.clusteringKeys) {
            this.columns.put(column.name(), column);
        }
        for (CqlField column : this.staticColumns) {
            this.columns.put(column.name(), column);
        }
        for (CqlField column : this.valueColumns) {
            this.columns.put(column.name(), column);
        }
        this.columnsWithUdts = this.determineColumnsWithUdts();
    }

    public TableIdentifier tableIdentifier() {
        return TableIdentifier.of(this.keyspace, this.table);
    }

    public ReplicationFactor replicationFactor() {
        return this.replicationFactor;
    }

    public CqlField column(String columnName) {
        return this.columns.get(columnName);
    }

    public List<CqlField> columns() {
        return new ArrayList<CqlField>(this.columns.values());
    }

    public List<CqlField> primaryKey() {
        ArrayList<CqlField> pk = new ArrayList<CqlField>(this.partitionKeys.size() + this.clusteringKeys.size());
        pk.addAll(this.partitionKeys);
        pk.addAll(this.clusteringKeys);
        return pk;
    }

    public List<CqlField> partitionKeys() {
        return this.partitionKeys;
    }

    public int numPartitionKeys() {
        return this.partitionKeys.size();
    }

    public List<CqlField> clusteringKeys() {
        return this.clusteringKeys;
    }

    public int numClusteringKeys() {
        return this.clusteringKeys.size();
    }

    public int numPrimaryKeyColumns() {
        return this.numPartitionKeys() + this.numClusteringKeys();
    }

    public int numNonValueColumns() {
        return this.numPartitionKeys() + this.numClusteringKeys() + this.numStaticColumns();
    }

    public List<CqlField> valueColumns() {
        return this.valueColumns;
    }

    public int numValueColumns() {
        return this.valueColumns.size();
    }

    public List<CqlField> staticColumns() {
        return this.staticColumns;
    }

    public int numStaticColumns() {
        return this.staticColumns.size();
    }

    public int numFields() {
        return this.fields.size();
    }

    public boolean has(String field) {
        return this.fieldsMap.containsKey(field);
    }

    public List<CqlField> fields() {
        return this.fields;
    }

    public CqlField field(int position) {
        return this.fields.get(position);
    }

    public Set<CqlField.CqlUdt> udts() {
        return this.udts;
    }

    public Set<String> udtCreateStmts(CassandraTypes cassandraTypes) {
        return this.udts.stream().map(udt -> udt.createStatement(cassandraTypes, this.keyspace)).collect(Collectors.toSet());
    }

    public CqlField getField(String name) {
        return this.fieldsMap.get(name);
    }

    public String keyspace() {
        return this.keyspace;
    }

    public String table() {
        return this.table;
    }

    public String createStatement() {
        return this.createStatement;
    }

    public int indexCount() {
        return this.indexCount;
    }

    private Set<String> determineColumnsWithUdts() {
        HashSet<String> columnsWithUdts = new HashSet<String>();
        for (Map.Entry<String, CqlField> field : this.fieldsMap.entrySet()) {
            if (field.getValue().type().udts().isEmpty()) continue;
            columnsWithUdts.add(field.getKey());
        }
        return columnsWithUdts;
    }

    public boolean containsUdt(String fieldName) {
        return this.columnsWithUdts.contains(fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.keyspace, this.table, this.createStatement, this.fields, this.udts);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        CqlTable that = (CqlTable)other;
        return Objects.equals(this.keyspace, that.keyspace) && Objects.equals(this.table, that.table) && Objects.equals(this.createStatement, that.createStatement) && Objects.equals(this.fields, that.fields) && Objects.equals(this.udts, that.udts);
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<CqlTable> {
        private final CassandraTypes cassandraTypes;

        public Serializer(CassandraTypes cassandraTypes) {
            this.cassandraTypes = cassandraTypes;
        }

        public CqlTable read(Kryo kryo, Input input, Class type) {
            String keyspace = input.readString();
            String table = input.readString();
            String createStatement = input.readString();
            ReplicationFactor replicationFactor = (ReplicationFactor)kryo.readObject(input, ReplicationFactor.class);
            int numFields = input.readInt();
            ArrayList<CqlField> fields = new ArrayList<CqlField>(numFields);
            for (int field = 0; field < numFields; ++field) {
                fields.add((CqlField)kryo.readObject(input, CqlField.class));
            }
            int numUdts = input.readInt();
            LinkedHashSet<CqlField.CqlUdt> udts = new LinkedHashSet<CqlField.CqlUdt>(numUdts);
            for (int udt = 0; udt < numUdts; ++udt) {
                udts.add((CqlField.CqlUdt)CqlField.CqlType.read(input, this.cassandraTypes));
            }
            int indexCount = input.readInt();
            return new CqlTable(keyspace, table, createStatement, replicationFactor, fields, udts, indexCount);
        }

        public void write(Kryo kryo, Output output, CqlTable table) {
            output.writeString(table.keyspace());
            output.writeString(table.table());
            output.writeString(table.createStatement());
            kryo.writeObject(output, (Object)table.replicationFactor());
            List<CqlField> fields = table.fields();
            output.writeInt(fields.size());
            for (CqlField field : fields) {
                kryo.writeObject(output, (Object)field);
            }
            Set<CqlField.CqlUdt> udts = table.udts();
            output.writeInt(udts.size());
            for (CqlField.CqlUdt udt : udts) {
                udt.write(output);
            }
            output.writeInt(table.indexCount());
        }
    }
}

