/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.esotericsoftware.kryo.io.Input;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.spark.data.CqlField;

public abstract class CassandraTypes {
    public static final Pattern COLLECTION_PATTERN = Pattern.compile("^(set|list|map|tuple)<(.+)>$", 2);
    public static final Pattern FROZEN_PATTERN = Pattern.compile("^frozen<(.*)>$", 2);
    private final UDTs udts = new UDTs();

    public abstract String maybeQuoteIdentifier(String var1);

    public static boolean isAlreadyQuoted(String identifier) {
        if (identifier != null && identifier.length() > 1) {
            return identifier.charAt(0) == '\"' && identifier.charAt(identifier.length() - 1) == '\"';
        }
        return false;
    }

    public abstract CqlField.CqlType readType(CqlField.CqlType.InternalType var1, Input var2);

    public List<CqlField.NativeType> allTypes() {
        return Arrays.asList(this.ascii(), this.bigint(), this.blob(), this.bool(), this.counter(), this.date(), this.decimal(), this.aDouble(), this.duration(), this.empty(), this.aFloat(), this.inet(), this.aInt(), this.smallint(), this.text(), this.time(), this.timestamp(), this.timeuuid(), this.tinyint(), this.uuid(), this.varchar(), this.varint());
    }

    public abstract Map<String, ? extends CqlField.NativeType> nativeTypeNames();

    public CqlField.NativeType nativeType(String name) {
        return this.nativeTypeNames().get(name.toLowerCase());
    }

    public List<CqlField.NativeType> supportedTypes() {
        return this.allTypes().stream().filter(CqlField.CqlType::isSupported).collect(Collectors.toList());
    }

    public abstract CqlField.NativeType ascii();

    public abstract CqlField.NativeType blob();

    public abstract CqlField.NativeType bool();

    public abstract CqlField.NativeType counter();

    public abstract CqlField.NativeType bigint();

    public abstract CqlField.NativeType date();

    public abstract CqlField.NativeType decimal();

    public abstract CqlField.NativeType aDouble();

    public abstract CqlField.NativeType duration();

    public abstract CqlField.NativeType empty();

    public abstract CqlField.NativeType aFloat();

    public abstract CqlField.NativeType inet();

    public abstract CqlField.NativeType aInt();

    public abstract CqlField.NativeType smallint();

    public abstract CqlField.NativeType text();

    public abstract CqlField.NativeType time();

    public abstract CqlField.NativeType timestamp();

    public abstract CqlField.NativeType timeuuid();

    public abstract CqlField.NativeType tinyint();

    public abstract CqlField.NativeType uuid();

    public abstract CqlField.NativeType varchar();

    public abstract CqlField.NativeType varint();

    public abstract CqlField.CqlType collection(String var1, CqlField.CqlType ... var2);

    public abstract CqlField.CqlList list(CqlField.CqlType var1);

    public abstract CqlField.CqlSet set(CqlField.CqlType var1);

    public abstract CqlField.CqlMap map(CqlField.CqlType var1, CqlField.CqlType var2);

    public abstract CqlField.CqlTuple tuple(CqlField.CqlType ... var1);

    public abstract CqlField.CqlType frozen(CqlField.CqlType var1);

    public abstract CqlField.CqlUdtBuilder udt(String var1, String var2);

    public CqlField.CqlType parseType(String type) {
        return this.parseType(type, Collections.emptyMap());
    }

    public CqlField.CqlType parseType(String keyspace, String type) {
        return this.parseType(type, this.udts.ofKeyspace(keyspace));
    }

    public void updateUDTs(String keyspace, CqlField.CqlUdt udt) {
        this.udts.put(keyspace, udt);
    }

    public CqlField.CqlType parseType(String type, Map<String, CqlField.CqlUdt> udts) {
        if (type == null || type.length() == 0) {
            return null;
        }
        Matcher collectionMatcher = COLLECTION_PATTERN.matcher(type);
        if (collectionMatcher.find()) {
            String[] types = CassandraTypes.splitInnerTypes(collectionMatcher.group(2));
            return this.collection(collectionMatcher.group(1), (CqlField.CqlType[])Stream.of(types).map(collectionType -> this.parseType((String)collectionType, udts)).toArray(CqlField.CqlType[]::new));
        }
        Matcher frozenMatcher = FROZEN_PATTERN.matcher(type);
        if (frozenMatcher.find()) {
            return this.frozen(this.parseType(frozenMatcher.group(1), udts));
        }
        if (udts.containsKey(type)) {
            return udts.get(type);
        }
        return this.nativeType(type);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    public static String[] splitInnerTypes(String str) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        int parentheses = 0;
        block6: for (int index = 0; index < str.length(); ++index) {
            char character = str.charAt(index);
            switch (character) {
                case ' ': {
                    if (parentheses != 0) break;
                    continue block6;
                }
                case ',': {
                    if (parentheses != 0) break;
                    if (current.length() <= 0) continue block6;
                    result.add(current.toString());
                    current = new StringBuilder();
                    continue block6;
                }
                case '<': {
                    ++parentheses;
                    break;
                }
                case '>': {
                    --parentheses;
                }
            }
            current.append(character);
        }
        if (current.length() > 0 || result.isEmpty()) {
            result.add(current.toString());
        }
        return result.toArray(new String[0]);
    }

    private static class UDTs {
        Map<String, Map<String, CqlField.CqlUdt>> udtByKeyspaceByTypeName = new ConcurrentHashMap<String, Map<String, CqlField.CqlUdt>>();

        private UDTs() {
        }

        void put(String keyspace, CqlField.CqlUdt udt) {
            Map udtByName = this.udtByKeyspaceByTypeName.computeIfAbsent(keyspace, x -> new ConcurrentHashMap());
            udtByName.put(udt.cqlName(), udt);
        }

        Map<String, CqlField.CqlUdt> ofKeyspace(String keyspace) {
            return this.udtByKeyspaceByTypeName.getOrDefault(keyspace, Collections.emptyMap());
        }
    }
}

