/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.api;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Objects;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.jetbrains.annotations.NotNull;

public class Marker
implements Comparable<Marker>,
Serializable {
    public static final Serializer SERIALIZER = new Serializer();
    public final CassandraInstance instance;
    public final long segmentId;
    public final int position;

    public static Marker origin(CassandraInstance instance) {
        return new Marker(instance, 0L, 0);
    }

    @JsonCreator
    public Marker(@JsonProperty(value="instance") CassandraInstance instance, @JsonProperty(value="segmentId") long segmentId, @JsonProperty(value="position") int position) {
        this.instance = instance;
        this.segmentId = segmentId;
        this.position = position;
    }

    @JsonGetter(value="segmentId")
    public long segmentId() {
        return this.segmentId;
    }

    @JsonGetter(value="instance")
    public CassandraInstance instance() {
        return this.instance;
    }

    @JsonGetter(value="position")
    public int position() {
        return this.position;
    }

    public static Marker min(@NotNull Marker m1, @NotNull Marker m2) {
        return m1.compareTo(m2) < 0 ? m1 : m2;
    }

    public boolean isBefore(@NotNull Marker o) {
        return this.compareTo(o) < 0;
    }

    @Override
    public int compareTo(@NotNull Marker o) {
        if (!this.instance.equals(o.instance)) {
            throw new IllegalArgumentException("CommitLog Markers should be on the same instance");
        }
        int c = Long.compare(this.segmentId, o.segmentId());
        if (c == 0) {
            return Integer.compare(this.position, o.position());
        }
        return c;
    }

    public String toString() {
        return String.format("{\"segmentId\": %d, \"position\": %d }", this.segmentId, this.position);
    }

    public int hashCode() {
        return Objects.hash(this.instance, this.segmentId, this.position);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Marker)) {
            return false;
        }
        Marker that = (Marker)other;
        return Objects.equals(this.instance, that.instance) && this.segmentId == that.segmentId && this.position == that.position;
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<Marker> {
        public void write(Kryo kryo, Output out, Marker o) {
            kryo.writeObject(out, (Object)o.instance, (com.esotericsoftware.kryo.Serializer)CassandraInstance.SERIALIZER);
            out.writeLong(o.segmentId);
            out.writeInt(o.position);
        }

        public Marker read(Kryo kryo, Input in, Class<Marker> type) {
            return new Marker((CassandraInstance)kryo.readObject(in, CassandraInstance.class, (com.esotericsoftware.kryo.Serializer)CassandraInstance.SERIALIZER), in.readLong(), in.readInt());
        }
    }
}

