/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import java.util.List;
import org.apache.cassandra.spark.data.DataLayer;
import org.apache.cassandra.spark.sparksql.CassandraInputPartition;
import org.apache.cassandra.spark.sparksql.SparkRowIterator;
import org.apache.cassandra.spark.sparksql.filters.PartitionKeyFilter;
import org.apache.spark.TaskContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraPartitionReaderFactory
implements PartitionReaderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraPartitionReaderFactory.class);
    final DataLayer dataLayer;
    final StructType requiredSchema;
    final List<PartitionKeyFilter> partitionKeyFilters;

    CassandraPartitionReaderFactory(DataLayer dataLayer, StructType requiredSchema, List<PartitionKeyFilter> partitionKeyFilters) {
        this.dataLayer = dataLayer;
        this.requiredSchema = requiredSchema;
        this.partitionKeyFilters = partitionKeyFilters;
    }

    public PartitionReader<InternalRow> createReader(InputPartition partition) {
        int partitionId;
        if (partition instanceof CassandraInputPartition) {
            partitionId = ((CassandraInputPartition)partition).getPartitionId();
        } else {
            partitionId = TaskContext.getPartitionId();
            LOGGER.warn("InputPartition is not of CassandraInputPartition type. Using TaskContext to determine the partitionId type={}, partitionId={}", (Object)partition.getClass().getName(), (Object)partitionId);
        }
        return new SparkRowIterator(partitionId, this.dataLayer, this.requiredSchema, this.partitionKeyFilters);
    }
}

