/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.partitioner;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.spark.data.SSTablesSupplier;
import org.apache.cassandra.spark.reader.SparkSSTableReader;

public class MultiDCReplicas
extends SSTablesSupplier {
    private final Map<String, SSTablesSupplier> replicasPerDC;

    public MultiDCReplicas(Map<String, SSTablesSupplier> replicasPerDC) {
        if (replicasPerDC == null || replicasPerDC.isEmpty()) {
            throw new IllegalArgumentException("replicasPerDC cannot be null or empty");
        }
        this.replicasPerDC = replicasPerDC;
    }

    public <T extends SparkSSTableReader> Set<T> openAll(SSTablesSupplier.ReaderOpener<T> readerOpener) {
        HashSet combinedReaders = new HashSet();
        this.replicasPerDC.values().forEach(supplier -> combinedReaders.addAll(supplier.openAll(readerOpener)));
        return combinedReaders;
    }
}

