/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.ConcurrentHashSet;
import org.apache.cassandra.bridge.SSTableDescriptor;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.SortedSSTableWriter;
import org.apache.cassandra.spark.bulkwriter.StreamError;
import org.apache.cassandra.spark.bulkwriter.StreamResult;
import org.apache.cassandra.spark.bulkwriter.TransportContext;
import org.apache.cassandra.spark.bulkwriter.token.ReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamSession<T extends TransportContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamSession.class);
    protected final BulkWriterContext writerContext;
    protected final T transportContext;
    protected final String sessionID;
    protected final Range<BigInteger> tokenRange;
    protected final List<RingInstance> replicas;
    protected final ArrayList<StreamError> errors = new ArrayList();
    protected final ReplicaAwareFailureHandler<RingInstance> failureHandler;
    protected final TokenRangeMapping<RingInstance> tokenRangeMapping;
    protected final SortedSSTableWriter sstableWriter;
    protected final ExecutorService executorService;
    private final Set<Path> streamedFiles = new ConcurrentHashSet();
    private final AtomicReference<Exception> lastStreamFailure = new AtomicReference();
    private volatile boolean isStreamFinalized = false;

    @VisibleForTesting
    protected StreamSession(BulkWriterContext writerContext, SortedSSTableWriter sstableWriter, T transportContext, String sessionID, Range<BigInteger> tokenRange, ReplicaAwareFailureHandler<RingInstance> failureHandler, ExecutorService executorService) {
        this.writerContext = writerContext;
        this.sstableWriter = sstableWriter;
        this.sstableWriter.setSSTablesProducedListener(this::onSSTablesProduced);
        this.transportContext = transportContext;
        this.tokenRangeMapping = writerContext.cluster().getTokenRangeMapping(true);
        this.sessionID = sessionID;
        this.tokenRange = tokenRange;
        this.failureHandler = failureHandler;
        this.replicas = this.getReplicas();
        this.executorService = executorService;
    }

    protected abstract void onSSTablesProduced(Set<SSTableDescriptor> var1);

    protected abstract StreamResult doFinalizeStream();

    protected abstract void sendRemainingSSTables();

    public Range<BigInteger> getTokenRange() {
        return this.tokenRange;
    }

    public void throwIfLastStreamFailed() throws IOException {
        if (this.lastStreamFailure.get() != null) {
            throw new IOException("Unexpected exception while streaming SSTables", this.lastStreamFailure.get());
        }
    }

    public void addRow(BigInteger token, Map<String, Object> boundValues) throws IOException {
        this.sstableWriter.addRow(token, boundValues);
    }

    public long rowCount() {
        return this.sstableWriter.rowCount();
    }

    public Future<StreamResult> finalizeStreamAsync() throws IOException {
        this.isStreamFinalized = true;
        Preconditions.checkState((!this.sstableWriter.getTokenRange().isEmpty() ? 1 : 0) != 0, (Object)"Cannot stream empty SSTable");
        Preconditions.checkState((boolean)this.tokenRange.encloses(this.sstableWriter.getTokenRange()), (String)"SSTable range %s should be enclosed in the partition range %s", (Object[])new Object[]{this.sstableWriter.getTokenRange(), this.tokenRange});
        try {
            this.sstableWriter.close(this.writerContext);
        }
        catch (IOException ioe) {
            this.cleanupSSTables(LOGGER);
            throw ioe;
        }
        return this.executorService.submit(this::doFinalizeStream);
    }

    protected boolean isStreamFinalized() {
        return this.isStreamFinalized;
    }

    protected boolean setLastStreamFailure(Exception streamFailure) {
        return this.lastStreamFailure.compareAndSet(null, streamFailure);
    }

    protected void recordStreamedFile(Path file) {
        this.streamedFiles.add(file);
    }

    protected boolean isFileStreamed(Path file) {
        return this.streamedFiles.contains(file);
    }

    @VisibleForTesting
    List<RingInstance> getReplicas() {
        Set<RingInstance> failedInstances = this.failureHandler.getFailedInstances();
        Map overlappingRanges = this.tokenRangeMapping.getSubRanges(this.tokenRange).asMapOfRanges();
        LOGGER.debug("[{}]: Stream session token range: {} overlaps with ring ranges: {}", new Object[]{this.sessionID, this.tokenRange, overlappingRanges});
        List<RingInstance> replicasForTokenRange = overlappingRanges.values().stream().flatMap(Collection::stream).distinct().filter(instance -> !failedInstances.contains(instance)).collect(Collectors.toList());
        Preconditions.checkState((!replicasForTokenRange.isEmpty() ? 1 : 0) != 0, (String)"No replicas found for range %s", (Object[])new Object[]{this.tokenRange});
        Collections.shuffle(replicasForTokenRange);
        return replicasForTokenRange;
    }

    protected void cleanupSSTables(Logger logger) {
        File tempDir = this.sstableWriter.getOutDir().toFile();
        logger.info("[{}]: Removing temporary files after stream session from {}", (Object)this.sessionID, (Object)tempDir);
        try {
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (IOException exception) {
            logger.warn("[{}]: Failed to delete temporary directory {}", new Object[]{this.sessionID, tempDir, exception});
        }
    }
}

