/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import org.apache.spark.serializer.JavaDeserializationStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkClassLoaderOverride
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkClassLoaderOverride.class);
    @NotNull
    private final ObjectInputStream in;
    @Nullable
    private final ClassLoader loader;

    public SparkClassLoaderOverride(@NotNull ObjectInputStream in, @NotNull ClassLoader loader) {
        this.in = in;
        this.loader = SparkClassLoaderOverride.swapClassLoader(in, loader);
    }

    @Nullable
    private static ClassLoader swapClassLoader(@NotNull ObjectInputStream in, @NotNull ClassLoader loader) {
        try {
            Field outerField = in.getClass().getDeclaredField("$outer");
            outerField.setAccessible(true);
            JavaDeserializationStream outerValue = (JavaDeserializationStream)outerField.get(in);
            Field loaderField = outerValue.getClass().getDeclaredField("org$apache$spark$serializer$JavaDeserializationStream$$loader");
            loaderField.setAccessible(true);
            ClassLoader loaderValue = (ClassLoader)loaderField.get(outerValue);
            loaderField.set(outerValue, loader);
            return loaderValue;
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException | NullPointerException exception) {
            LOGGER.warn("Cannot override class loader in a Spark object input stream", (Throwable)exception);
            return null;
        }
    }

    @Override
    public void close() {
        if (this.loader != null) {
            SparkClassLoaderOverride.swapClassLoader(this.in, this.loader);
        }
    }
}

