/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.heap;

import java.util.Comparator;
import org.psjava.ds.array.ArraySwapper;
import org.psjava.ds.array.DynamicArray;
import org.psjava.ds.heap.Heap;
import org.psjava.ds.heap.HeapNode;
import org.psjava.util.AssertStatus;

public class BinaryHeap<T>
implements Heap<T> {
    private final DynamicArray<Node> array = DynamicArray.create();
    private final Comparator<T> comparator;

    public BinaryHeap(Iterable<T> initialItems, Comparator<T> comparator) {
        this.comparator = comparator;
        for (T v : initialItems) {
            this.array.addToLast(new Node(this.array.size(), v));
        }
        for (int i = this.array.size() / 2 - 1; i >= 0; --i) {
            this.heapify(i);
        }
    }

    @Override
    public HeapNode<T> insert(T v) {
        Node node = new Node(this.array.size(), v);
        this.array.addToLast(node);
        this.decreaseKey(node.pos);
        return node;
    }

    @Override
    public T getMinimum() {
        AssertStatus.assertTrue(!this.isEmpty(), "empty");
        return this.array.get((int)0).key;
    }

    @Override
    public T extractMinimum() {
        AssertStatus.assertTrue(!this.isEmpty(), "heap is empty");
        this.swapNode(0, this.array.size() - 1);
        Node r = this.array.removeLast();
        this.heapify(0);
        r.pos = -1;
        return r.key;
    }

    @Override
    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    private void swapNode(int i, int j) {
        ArraySwapper.swap(this.array, i, j);
        this.array.get((int)i).pos = i;
        this.array.get((int)j).pos = j;
    }

    private void heapify(int i) {
        while (true) {
            int left = i << 1;
            int right = (i << 1) + 1;
            int smallest = i;
            if (left < this.array.size() && this.compare(this.array.get(left), this.array.get(smallest)) < 0) {
                smallest = left;
            }
            if (right < this.array.size() && this.compare(this.array.get(right), this.array.get(smallest)) < 0) {
                smallest = right;
            }
            if (smallest == i) break;
            this.swapNode(smallest, i);
            i = smallest;
        }
    }

    private void decreaseKey(int pos) {
        while (pos > 0 && this.compare(this.array.get(pos), this.array.get(pos >> 1)) < 0) {
            this.swapNode(pos >> 1, pos);
            pos >>= 1;
        }
    }

    private void delete(int pos) {
        this.forceToRoot(pos);
        this.extractMinimum();
    }

    private void forceToRoot(int pos) {
        while (pos > 0) {
            this.swapNode(pos >> 1, pos);
            pos >>= 1;
        }
    }

    private int compare(Node v1, Node v2) {
        return this.comparator.compare(v1.getKey(), v2.getKey());
    }

    public String toString() {
        return this.array.toString();
    }

    private class Node
    implements HeapNode<T> {
        int pos;
        T key;

        Node(int pos, T key) {
            this.pos = pos;
            this.key = key;
        }

        @Override
        public T getKey() {
            this.assertNotDeleted();
            return this.key;
        }

        @Override
        public boolean isInHeap() {
            return this.pos != -1;
        }

        @Override
        public void decreaseKey(T key) {
            this.assertNotDeleted();
            this.key = key;
            BinaryHeap.this.decreaseKey(this.pos);
        }

        @Override
        public void delete() {
            this.assertNotDeleted();
            BinaryHeap.this.delete(this.pos);
        }

        private void assertNotDeleted() {
            AssertStatus.assertTrue(this.pos != -1, "Node is not in heap (deleted)");
        }

        public String toString() {
            return this.key.toString();
        }
    }
}

