/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.cassandra.net.AsyncPromise;

public class AsyncChannelPromise
extends AsyncPromise<Void>
implements ChannelPromise {
    private final Channel channel;

    public AsyncChannelPromise(Channel channel) {
        super(channel.eventLoop());
        this.channel = channel;
    }

    AsyncChannelPromise(Channel channel, GenericFutureListener<? extends Future<? super Void>> listener) {
        super((EventExecutor)channel.eventLoop(), listener);
        this.channel = channel;
    }

    public static AsyncChannelPromise withListener(ChannelHandlerContext context, GenericFutureListener<? extends Future<? super Void>> listener) {
        return AsyncChannelPromise.withListener(context.channel(), listener);
    }

    public static AsyncChannelPromise withListener(Channel channel, GenericFutureListener<? extends Future<? super Void>> listener) {
        return new AsyncChannelPromise(channel, listener);
    }

    public static ChannelFuture writeAndFlush(ChannelHandlerContext context, Object message, GenericFutureListener<? extends Future<? super Void>> listener) {
        return context.writeAndFlush(message, AsyncChannelPromise.withListener(context.channel(), listener));
    }

    public static ChannelFuture writeAndFlush(Channel channel, Object message, GenericFutureListener<? extends Future<? super Void>> listener) {
        return channel.writeAndFlush(message, AsyncChannelPromise.withListener(channel, listener));
    }

    public static ChannelFuture writeAndFlush(ChannelHandlerContext context, Object message) {
        return context.writeAndFlush(message, new AsyncChannelPromise(context.channel()));
    }

    public static ChannelFuture writeAndFlush(Channel channel, Object message) {
        return channel.writeAndFlush(message, new AsyncChannelPromise(channel));
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public boolean isVoid() {
        return false;
    }

    @Override
    public ChannelPromise setSuccess() {
        return this.setSuccess(null);
    }

    @Override
    public ChannelPromise setSuccess(Void v) {
        super.setSuccess(v);
        return this;
    }

    @Override
    public boolean trySuccess() {
        return this.trySuccess(null);
    }

    @Override
    public ChannelPromise setFailure(Throwable throwable) {
        super.setFailure(throwable);
        return this;
    }

    @Override
    public ChannelPromise sync() throws InterruptedException {
        super.sync();
        return this;
    }

    @Override
    public ChannelPromise syncUninterruptibly() {
        super.syncUninterruptibly();
        return this;
    }

    @Override
    public ChannelPromise await() throws InterruptedException {
        super.await();
        return this;
    }

    @Override
    public ChannelPromise awaitUninterruptibly() {
        super.awaitUninterruptibly();
        return this;
    }

    @Override
    public ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        super.addListener(listener);
        return this;
    }

    @Override
    public ChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        super.addListeners(listeners);
        return this;
    }

    @Override
    public ChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        super.removeListener(listener);
        return this;
    }

    @Override
    public ChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        super.removeListeners(listeners);
        return this;
    }

    @Override
    public ChannelPromise unvoid() {
        return this;
    }
}

