/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.CommandSuggester;
import io.airlift.airline.Context;
import io.airlift.airline.DefaultCommandFactory;
import io.airlift.airline.GlobalSuggester;
import io.airlift.airline.GroupSuggester;
import io.airlift.airline.ParseState;
import io.airlift.airline.Parser;
import io.airlift.airline.ParserUtil;
import io.airlift.airline.Suggester;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import io.airlift.airline.model.MetadataLoader;
import io.airlift.airline.model.SuggesterMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;

@Command(name="suggest")
public class SuggestCommand
implements Runnable,
Callable<Void> {
    private static final Map<Context, Class<? extends Suggester>> BUILTIN_SUGGESTERS = ImmutableMap.builder().put(Context.GLOBAL, GlobalSuggester.class).put(Context.GROUP, GroupSuggester.class).put(Context.COMMAND, CommandSuggester.class).build();
    @Inject
    public GlobalMetadata metadata;
    @Arguments
    public List<String> arguments = new ArrayList<String>();

    @VisibleForTesting
    public Iterable<String> generateSuggestions() {
        SuggesterMetadata suggesterMetadata;
        Parser parser = new Parser();
        ParseState state = parser.parse(this.metadata, this.arguments);
        Class<? extends Suggester> suggesterClass = BUILTIN_SUGGESTERS.get((Object)state.getLocation());
        if (suggesterClass != null && (suggesterMetadata = MetadataLoader.loadSuggester(suggesterClass)) != null) {
            ImmutableMap.Builder<Class<GlobalMetadata>, GlobalMetadata> bindings = ImmutableMap.builder().put(GlobalMetadata.class, this.metadata);
            if (state.getGroup() != null) {
                bindings.put(CommandGroupMetadata.class, (GlobalMetadata)((Object)state.getGroup()));
            }
            if (state.getCommand() != null) {
                bindings.put(CommandMetadata.class, (GlobalMetadata)((Object)state.getCommand()));
            }
            Suggester suggester = (Suggester)ParserUtil.createInstance(suggesterMetadata.getSuggesterClass(), ImmutableList.of(), null, null, null, suggesterMetadata.getMetadataInjections(), bindings.build(), new DefaultCommandFactory());
            return suggester.suggest();
        }
        return ImmutableList.of();
    }

    @Override
    public void run() {
        System.out.println(Joiner.on("\n").join(this.generateSuggestions()));
    }

    @Override
    public Void call() {
        this.run();
        return null;
    }
}

