/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.util.formating;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;

public class TextTree {
    private String text;
    private TextTree[] children;

    public static TextTree t(String text, TextTree ... children) {
        return new TextTree(text, children);
    }

    public TextTree(String text, TextTree ... children) {
        this.text = text;
        this.children = children;
    }

    public String printAsTree() {
        try {
            StringWriter sw = new StringWriter();
            TextTree.printTreeNode(sw, "", this, false);
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void printAsTree(Appendable stream) throws IOException {
        TextTree.printTreeNode(stream, "", this, false);
    }

    public void printAsTree(Appendable stream, boolean compact) throws IOException {
        TextTree.printTreeNode(stream, "", this, compact);
    }

    private static void printTreeNode(Appendable sb, String prefix, TextTree node, boolean compact) throws IOException {
        String t2 = String.valueOf(node.text);
        sb.append(t2);
        if (node.children.length == 0) {
            sb.append('\n');
        } else {
            String npref = prefix + TextTree.blank(t2.length()) + (!compact ? "| " : "|");
            String cpref = prefix + TextTree.blank(t2.length());
            if (node.children.length == 1) {
                sb.append(!compact ? "--" : "-");
                npref = cpref + (!compact ? "  " : " ");
            } else {
                sb.append(!compact ? "+-" : "+");
            }
            TextTree.printTreeNode(sb, npref, node.children[0], compact);
            for (int i = 1; i < node.children.length; ++i) {
                sb.append(cpref);
                if (i < node.children.length - 1) {
                    sb.append(!compact ? "+-" : "+");
                    TextTree.printTreeNode(sb, npref, node.children[i], compact);
                    continue;
                }
                sb.append(!compact ? "\\-" : "\\");
                TextTree.printTreeNode(sb, cpref + (!compact ? "  " : " "), node.children[i], compact);
            }
        }
    }

    private static String blank(int n) {
        char[] ch = new char[n];
        Arrays.fill(ch, ' ');
        return new String(ch);
    }

    public String toString() {
        return this.text + (this.children.length == 0 ? "" : Arrays.toString(this.children));
    }
}

