/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.event;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.MultiCounterEvent;
import org.gridkit.jvmtool.event.SimpleCounterCollection;
import org.gridkit.jvmtool.event.SimpleTagCollection;
import org.gridkit.jvmtool.event.TaggedEvent;
import org.gridkit.jvmtool.event.TimestampedEvent;

public class EventDecorator {
    private long timestamp = -1L;
    private SimpleTagCollection tags = new SimpleTagCollection();
    private SimpleCounterCollection counters = new SimpleCounterCollection();
    private Map<Class<?>, Event> wrapperCache = new HashMap();
    private InvocationHandler handler = new Handler();
    private Event delegate;

    public <T extends Event> T wrap(T event) {
        Event proxy;
        if (event == null) {
            return null;
        }
        this.timestamp = -1L;
        this.tags.clear();
        this.counters.clear();
        this.delegate = event;
        if (event instanceof TimestampedEvent) {
            this.timestamp = ((TimestampedEvent)((Object)event)).timestamp();
        }
        if (event instanceof MultiCounterEvent) {
            this.counters.setAll(((MultiCounterEvent)event).counters());
        }
        if (event instanceof TaggedEvent) {
            this.tags.putAll(((TaggedEvent)event).tags());
        }
        if ((proxy = this.wrapperCache.get(event.getClass())) == null) {
            this.initProxy(event.getClass());
            proxy = this.wrapperCache.get(event.getClass());
        }
        return (T)proxy;
    }

    private void initProxy(Class<? extends Event> type) {
        ArrayList facade = new ArrayList();
        for (Class<?> clazz : type.getInterfaces()) {
            if (!Event.class.isAssignableFrom(clazz)) continue;
            facade.add(clazz);
        }
        if (facade.isEmpty()) {
            throw new IllegalArgumentException("Invalid event type: " + type.getClass());
        }
        block1: while (true) {
            block2: for (Class clazz : facade) {
                for (Class clazz2 : facade) {
                    if (clazz == clazz2 || !clazz.isAssignableFrom(clazz2)) continue;
                    facade.remove(clazz);
                    continue block1;
                    continue block2;
                }
            }
            break;
        }
        Object proxy = Proxy.newProxyInstance(((Class)facade.get(0)).getClassLoader(), facade.toArray(new Class[0]), this.handler);
        this.wrapperCache.put(type, (Event)proxy);
    }

    public void timestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public SimpleTagCollection tags() {
        return this.tags;
    }

    public SimpleCounterCollection counters() {
        return this.counters;
    }

    private class Handler
    implements InvocationHandler {
        private Handler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args == null || args.length == 0) {
                if ("timestamp".equals(method.getName())) {
                    return EventDecorator.this.timestamp;
                }
                if ("tags".equals(method.getName())) {
                    return EventDecorator.this.tags;
                }
                if ("counters".equals(method.getName())) {
                    return EventDecorator.this.counters;
                }
            }
            return method.invoke((Object)EventDecorator.this.delegate, args);
        }
    }
}

