/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.DocumentsWriterDeleteQueue;
import org.apache.lucene.index.DocumentsWriterFlushControl;
import org.apache.lucene.index.DocumentsWriterFlushQueue;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.DocumentsWriterPerThreadPool;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.IOConsumer;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;

final class DocumentsWriter
implements Closeable,
Accountable {
    private final AtomicLong pendingNumDocs;
    private final FlushNotifications flushNotifications;
    private volatile boolean closed;
    private final InfoStream infoStream;
    private final LiveIndexWriterConfig config;
    private final AtomicInteger numDocsInRAM = new AtomicInteger(0);
    volatile DocumentsWriterDeleteQueue deleteQueue;
    private final DocumentsWriterFlushQueue ticketQueue = new DocumentsWriterFlushQueue();
    private volatile boolean pendingChangesInCurrentFullFlush;
    final DocumentsWriterPerThreadPool perThreadPool;
    final DocumentsWriterFlushControl flushControl;
    private volatile DocumentsWriterDeleteQueue currentFullFlushDelQueue = null;

    DocumentsWriter(FlushNotifications flushNotifications, int indexCreatedVersionMajor, AtomicLong pendingNumDocs, boolean enableTestPoints, Supplier<String> segmentNameSupplier, LiveIndexWriterConfig config, Directory directoryOrig, Directory directory, FieldInfos.FieldNumbers globalFieldNumberMap) {
        this.config = config;
        this.infoStream = config.getInfoStream();
        this.deleteQueue = new DocumentsWriterDeleteQueue(this.infoStream);
        this.perThreadPool = new DocumentsWriterPerThreadPool(() -> {
            FieldInfos.Builder infos = new FieldInfos.Builder(globalFieldNumberMap);
            return new DocumentsWriterPerThread(indexCreatedVersionMajor, (String)segmentNameSupplier.get(), directoryOrig, directory, config, this.deleteQueue, infos, pendingNumDocs, enableTestPoints);
        });
        this.pendingNumDocs = pendingNumDocs;
        this.flushControl = new DocumentsWriterFlushControl(this, config);
        this.flushNotifications = flushNotifications;
    }

    long deleteQueries(Query ... queries) throws IOException {
        return this.applyDeleteOrUpdate(q -> q.addDelete(queries));
    }

    long deleteTerms(Term ... terms) throws IOException {
        return this.applyDeleteOrUpdate(q -> q.addDelete(terms));
    }

    long updateDocValues(DocValuesUpdate ... updates) throws IOException {
        return this.applyDeleteOrUpdate(q -> q.addDocValuesUpdates(updates));
    }

    private synchronized long applyDeleteOrUpdate(ToLongFunction<DocumentsWriterDeleteQueue> function) throws IOException {
        DocumentsWriterDeleteQueue deleteQueue = this.deleteQueue;
        long seqNo = function.applyAsLong(deleteQueue);
        this.flushControl.doOnDelete();
        if (this.applyAllDeletes()) {
            seqNo = -seqNo;
        }
        return seqNo;
    }

    private boolean applyAllDeletes() throws IOException {
        DocumentsWriterDeleteQueue deleteQueue = this.deleteQueue;
        if (!this.flushControl.isFullFlush() && deleteQueue.isOpen() && this.flushControl.getAndResetApplyAllDeletes() && this.ticketQueue.addDeletes(deleteQueue)) {
            this.flushNotifications.onDeletesApplied();
            return true;
        }
        return false;
    }

    void purgeFlushTickets(boolean forced, IOConsumer<DocumentsWriterFlushQueue.FlushTicket> consumer) throws IOException {
        if (forced) {
            this.ticketQueue.forcePurge(consumer);
        } else {
            this.ticketQueue.tryPurge(consumer);
        }
    }

    int getNumDocs() {
        return this.numDocsInRAM.get();
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this DocumentsWriter is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void abort() throws IOException {
        boolean success = false;
        try {
            this.deleteQueue.clear();
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "abort");
            }
            for (DocumentsWriterPerThread perThread : this.perThreadPool.filterAndLock(x -> true)) {
                try {
                    this.abortDocumentsWriterPerThread(perThread);
                }
                finally {
                    perThread.unlock();
                }
            }
            this.flushControl.abortPendingFlushes();
            this.flushControl.waitForFlush();
            assert (this.perThreadPool.size() == 0) : "There are still active DWPT in the pool: " + this.perThreadPool.size();
            success = true;
        }
        finally {
            if (success) {
                assert (this.flushControl.getFlushingBytes() == 0L) : "flushingBytes has unexpected value 0 != " + this.flushControl.getFlushingBytes();
                assert (this.flushControl.netBytes() == 0L) : "netBytes has unexpected value 0 != " + this.flushControl.netBytes();
            }
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "done abort success=" + success);
            }
        }
    }

    final boolean flushOneDWPT() throws IOException {
        DocumentsWriterPerThread documentsWriterPerThread;
        if (this.infoStream.isEnabled("DW")) {
            this.infoStream.message("DW", "startFlushOneDWPT");
        }
        if ((documentsWriterPerThread = this.flushControl.nextPendingFlush()) == null) {
            documentsWriterPerThread = this.flushControl.checkoutLargestNonPendingWriter();
        }
        if (documentsWriterPerThread != null) {
            return this.doFlush(documentsWriterPerThread);
        }
        return false;
    }

    synchronized Closeable lockAndAbortAll() throws IOException {
        if (this.infoStream.isEnabled("DW")) {
            this.infoStream.message("DW", "lockAndAbortAll");
        }
        this.ticketQueue.forcePurge(ticket -> {
            if (ticket.getFlushedSegment() != null) {
                this.pendingNumDocs.addAndGet(-ticket.getFlushedSegment().segmentInfo.info.maxDoc());
            }
        });
        ArrayList<DocumentsWriterPerThread> writers = new ArrayList<DocumentsWriterPerThread>();
        AtomicBoolean released = new AtomicBoolean(false);
        Closeable release = () -> {
            if (released.compareAndSet(false, true)) {
                if (this.infoStream.isEnabled("DW")) {
                    this.infoStream.message("DW", "unlockAllAbortedThread");
                }
                this.perThreadPool.unlockNewWriters();
                for (DocumentsWriterPerThread writer : writers) {
                    writer.unlock();
                }
            }
        };
        try {
            this.deleteQueue.clear();
            this.perThreadPool.lockNewWriters();
            writers.addAll(this.perThreadPool.filterAndLock(x -> true));
            for (DocumentsWriterPerThread perThread : writers) {
                assert (perThread.isHeldByCurrentThread());
                this.abortDocumentsWriterPerThread(perThread);
            }
            this.deleteQueue.clear();
            this.deleteQueue.skipSequenceNumbers(this.perThreadPool.size() + 1);
            this.flushControl.abortPendingFlushes();
            this.flushControl.waitForFlush();
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "finished lockAndAbortAll success=true");
            }
            return release;
        }
        catch (Throwable t2) {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "finished lockAndAbortAll success=false");
            }
            try {
                release.close();
            }
            catch (Throwable t1) {
                t2.addSuppressed(t1);
            }
            throw t2;
        }
    }

    private void abortDocumentsWriterPerThread(DocumentsWriterPerThread perThread) throws IOException {
        assert (perThread.isHeldByCurrentThread());
        try {
            this.subtractFlushedNumDocs(perThread.getNumDocsInRAM());
            perThread.abort();
        }
        finally {
            this.flushControl.doOnAbort(perThread);
        }
    }

    long getMaxCompletedSequenceNumber() {
        return this.deleteQueue.getMaxCompletedSeqNo();
    }

    boolean anyChanges() {
        boolean anyChanges;
        boolean bl = anyChanges = this.numDocsInRAM.get() != 0 || this.anyDeletions() || this.ticketQueue.hasTickets() || this.pendingChangesInCurrentFullFlush;
        if (this.infoStream.isEnabled("DW") && anyChanges) {
            this.infoStream.message("DW", "anyChanges? numDocsInRam=" + this.numDocsInRAM.get() + " deletes=" + this.anyDeletions() + " hasTickets:" + this.ticketQueue.hasTickets() + " pendingChangesInFullFlush: " + this.pendingChangesInCurrentFullFlush);
        }
        return anyChanges;
    }

    int getBufferedDeleteTermsSize() {
        return this.deleteQueue.getBufferedUpdatesTermsSize();
    }

    int getNumBufferedDeleteTerms() {
        return this.deleteQueue.numGlobalTermDeletes();
    }

    boolean anyDeletions() {
        return this.deleteQueue.anyChanges();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        IOUtils.close(this.flushControl, this.perThreadPool);
    }

    private boolean preUpdate() throws IOException {
        this.ensureOpen();
        boolean hasEvents = false;
        while (this.flushControl.anyStalledThreads() || this.flushControl.numQueuedFlushes() > 0 && this.config.checkPendingFlushOnUpdate) {
            DocumentsWriterPerThread flushingDWPT;
            while ((flushingDWPT = this.flushControl.nextPendingFlush()) != null) {
                hasEvents |= this.doFlush(flushingDWPT);
            }
            this.flushControl.waitIfStalled();
        }
        return hasEvents;
    }

    private boolean postUpdate(DocumentsWriterPerThread flushingDWPT, boolean hasEvents) throws IOException {
        DocumentsWriterPerThread nextPendingFlush;
        hasEvents |= this.applyAllDeletes();
        if (flushingDWPT != null) {
            hasEvents |= this.doFlush(flushingDWPT);
        } else if (this.config.checkPendingFlushOnUpdate && (nextPendingFlush = this.flushControl.nextPendingFlush()) != null) {
            hasEvents |= this.doFlush(nextPendingFlush);
        }
        return hasEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long updateDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs, DocumentsWriterDeleteQueue.Node<?> delNode) throws IOException {
        DocumentsWriterPerThread flushingDWPT;
        long seqNo;
        boolean hasEvents = this.preUpdate();
        DocumentsWriterPerThread dwpt = this.flushControl.obtainAndLock();
        try {
            this.ensureOpen();
            try {
                seqNo = dwpt.updateDocuments(docs, delNode, this.flushNotifications, this.numDocsInRAM::incrementAndGet);
            }
            finally {
                if (dwpt.isAborted()) {
                    this.flushControl.doOnAbort(dwpt);
                }
            }
            flushingDWPT = this.flushControl.doAfterDocument(dwpt);
        }
        finally {
            if (dwpt.isFlushPending() || dwpt.isAborted()) {
                dwpt.unlock();
            } else {
                this.perThreadPool.marksAsFreeAndUnlock(dwpt);
            }
            assert (!dwpt.isHeldByCurrentThread()) : "we didn't release the dwpt even on abort";
        }
        if (this.postUpdate(flushingDWPT, hasEvents)) {
            seqNo = -seqNo;
        }
        return seqNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlush(DocumentsWriterPerThread flushingDWPT) throws IOException {
        double ramBufferSizeMB;
        boolean hasEvents = false;
        while (flushingDWPT != null) {
            assert (!flushingDWPT.hasFlushed());
            hasEvents = true;
            boolean success = false;
            DocumentsWriterFlushQueue.FlushTicket ticket = null;
            try {
                assert (this.currentFullFlushDelQueue == null || flushingDWPT.deleteQueue == this.currentFullFlushDelQueue) : "expected: " + this.currentFullFlushDelQueue + "but was: " + flushingDWPT.deleteQueue + " " + this.flushControl.isFullFlush();
                try {
                    assert (this.assertTicketQueueModification(flushingDWPT.deleteQueue));
                    ticket = this.ticketQueue.addFlushTicket(flushingDWPT);
                    int flushingDocsInRam = flushingDWPT.getNumDocsInRAM();
                    boolean dwptSuccess = false;
                    try {
                        DocumentsWriterPerThread.FlushedSegment newSegment = flushingDWPT.flush(this.flushNotifications);
                        this.ticketQueue.addSegment(ticket, newSegment);
                        dwptSuccess = true;
                    }
                    finally {
                        this.subtractFlushedNumDocs(flushingDocsInRam);
                        if (!flushingDWPT.pendingFilesToDelete().isEmpty()) {
                            Set<String> files = flushingDWPT.pendingFilesToDelete();
                            this.flushNotifications.deleteUnusedFiles(files);
                            hasEvents = true;
                        }
                        if (!dwptSuccess) {
                            this.flushNotifications.flushFailed(flushingDWPT.getSegmentInfo());
                            hasEvents = true;
                        }
                    }
                    success = true;
                }
                finally {
                    if (!success && ticket != null) {
                        this.ticketQueue.markTicketFailed(ticket);
                    }
                }
                if (this.ticketQueue.getTicketCount() >= this.perThreadPool.size()) {
                    this.flushNotifications.onTicketBacklog();
                    break;
                }
            }
            finally {
                this.flushControl.doAfterFlush(flushingDWPT);
            }
            flushingDWPT = this.flushControl.nextPendingFlush();
        }
        if (hasEvents) {
            this.flushNotifications.afterSegmentsFlushed();
        }
        if ((ramBufferSizeMB = this.config.getRAMBufferSizeMB()) != -1.0 && (double)this.flushControl.getDeleteBytesUsed() > 1048576.0 * ramBufferSizeMB / 2.0) {
            hasEvents = true;
            if (!this.applyAllDeletes()) {
                if (this.infoStream.isEnabled("DW")) {
                    this.infoStream.message("DW", String.format(Locale.ROOT, "force apply deletes after flush bytesUsed=%.1f MB vs ramBuffer=%.1f MB", (double)this.flushControl.getDeleteBytesUsed() / 1048576.0, ramBufferSizeMB));
                }
                this.flushNotifications.onDeletesApplied();
            }
        }
        return hasEvents;
    }

    synchronized long getNextSequenceNumber() {
        return this.deleteQueue.getNextSequenceNumber();
    }

    synchronized void resetDeleteQueue(DocumentsWriterDeleteQueue newQueue) {
        assert (this.deleteQueue.isAdvanced());
        assert (!newQueue.isAdvanced());
        assert (this.deleteQueue.getLastSequenceNumber() <= newQueue.getLastSequenceNumber());
        assert (this.deleteQueue.getMaxSeqNo() <= newQueue.getLastSequenceNumber()) : "maxSeqNo: " + this.deleteQueue.getMaxSeqNo() + " vs. " + newQueue.getLastSequenceNumber();
        this.deleteQueue = newQueue;
    }

    void subtractFlushedNumDocs(int numFlushed) {
        int oldValue = this.numDocsInRAM.get();
        while (!this.numDocsInRAM.compareAndSet(oldValue, oldValue - numFlushed)) {
            oldValue = this.numDocsInRAM.get();
        }
        assert (this.numDocsInRAM.get() >= 0);
    }

    private synchronized boolean setFlushingDeleteQueue(DocumentsWriterDeleteQueue session) {
        assert (this.currentFullFlushDelQueue == null || !this.currentFullFlushDelQueue.isOpen()) : "Can not replace a full flush queue if the queue is not closed";
        this.currentFullFlushDelQueue = session;
        return true;
    }

    private boolean assertTicketQueueModification(DocumentsWriterDeleteQueue deleteQueue) {
        DocumentsWriterDeleteQueue currentFullFlushDelQueue = this.currentFullFlushDelQueue;
        assert (currentFullFlushDelQueue == null || currentFullFlushDelQueue == deleteQueue) : "only modifications from the current flushing queue are permitted while doing a full flush";
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long flushAllThreads() throws IOException {
        long seqNo;
        DocumentsWriterDeleteQueue flushingDeleteQueue;
        if (this.infoStream.isEnabled("DW")) {
            this.infoStream.message("DW", "startFullFlush");
        }
        DocumentsWriter documentsWriter = this;
        synchronized (documentsWriter) {
            this.pendingChangesInCurrentFullFlush = this.anyChanges();
            flushingDeleteQueue = this.deleteQueue;
            seqNo = this.flushControl.markForFullFlush();
            assert (this.setFlushingDeleteQueue(flushingDeleteQueue));
        }
        assert (this.currentFullFlushDelQueue != null);
        assert (this.currentFullFlushDelQueue != this.deleteQueue);
        boolean anythingFlushed = false;
        try {
            DocumentsWriterPerThread flushingDWPT;
            while ((flushingDWPT = this.flushControl.nextPendingFlush()) != null) {
                anythingFlushed |= this.doFlush(flushingDWPT);
            }
            this.flushControl.waitForFlush();
            if (!anythingFlushed && flushingDeleteQueue.anyChanges()) {
                if (this.infoStream.isEnabled("DW")) {
                    this.infoStream.message("DW", Thread.currentThread().getName() + ": flush naked frozen global deletes");
                }
                assert (this.assertTicketQueueModification(flushingDeleteQueue));
                this.ticketQueue.addDeletes(flushingDeleteQueue);
            }
            assert (!flushingDeleteQueue.anyChanges());
        }
        finally {
            assert (flushingDeleteQueue == this.currentFullFlushDelQueue);
            flushingDeleteQueue.close();
        }
        if (anythingFlushed) {
            return -seqNo;
        }
        return seqNo;
    }

    void finishFullFlush(boolean success) throws IOException {
        try {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", Thread.currentThread().getName() + " finishFullFlush success=" + success);
            }
            assert (this.setFlushingDeleteQueue(null));
            if (success) {
                this.flushControl.finishFullFlush();
            } else {
                this.flushControl.abortFullFlushes();
            }
        }
        finally {
            this.pendingChangesInCurrentFullFlush = false;
            this.applyAllDeletes();
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.flushControl.ramBytesUsed();
    }

    long getFlushingBytes() {
        return this.flushControl.getFlushingBytes();
    }

    static interface FlushNotifications {
        public void deleteUnusedFiles(Collection<String> var1);

        public void flushFailed(SegmentInfo var1);

        public void afterSegmentsFlushed() throws IOException;

        public void onTragicEvent(Throwable var1, String var2);

        public void onDeletesApplied();

        public void onTicketBacklog();
    }
}

