/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.cassandra.utils.concurrent.LightweightRecyclerPoolHolder;

public interface LightweightRecycler<T>
extends LightweightRecyclerPoolHolder<T> {
    default public T reuse() {
        return this.get().pollFirst();
    }

    default public T reuseOrAllocate(Supplier<T> supplier) {
        T reuse = this.reuse();
        return reuse != null ? reuse : supplier.get();
    }

    default public boolean tryRecycle(T t2) {
        Objects.requireNonNull(t2);
        ArrayDeque pool = this.get();
        if (pool.size() < this.capacity()) {
            if (t2 instanceof Collection) {
                ((Collection)t2).clear();
            }
            pool.offerFirst(t2);
            return true;
        }
        return false;
    }

    default public int available() {
        return this.get().size();
    }

    public int capacity();
}

