/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class RangesSerializer
implements IVersionedSerializer<Collection<Range<Token>>> {
    public static final RangesSerializer serializer = new RangesSerializer();

    @Override
    public void serialize(Collection<Range<Token>> ranges, DataOutputPlus out, int version) throws IOException {
        out.writeInt(ranges.size());
        for (Range<Token> r : ranges) {
            Token.serializer.serialize((Token)r.left, out, version);
            Token.serializer.serialize((Token)r.right, out, version);
        }
    }

    @Override
    public Collection<Range<Token>> deserialize(DataInputPlus in, int version) throws IOException {
        int count = in.readInt();
        ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(count);
        IPartitioner partitioner = DatabaseDescriptor.getPartitioner();
        for (int i = 0; i < count; ++i) {
            Token start = Token.serializer.deserialize(in, partitioner, version);
            Token end = Token.serializer.deserialize(in, partitioner, version);
            ranges.add(new Range<Token>(start, end));
        }
        return ranges;
    }

    @Override
    public long serializedSize(Collection<Range<Token>> ranges, int version) {
        int size = TypeSizes.sizeof(ranges.size());
        if (ranges.size() > 0) {
            size = (int)((long)size + (long)(ranges.size() * 2) * Token.serializer.serializedSize((Token)ranges.iterator().next().left, version));
        }
        return size;
    }
}

