/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.RangesAtEndpoint;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.streaming.OutgoingStream;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.streaming.StreamCoordinator;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamOperation;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamingChannel;
import org.apache.cassandra.utils.TimeUUID;

public class StreamPlan {
    private static final String[] EMPTY_COLUMN_FAMILIES = new String[0];
    private final TimeUUID planId = TimeUUID.Generator.nextTimeUUID();
    private final StreamOperation streamOperation;
    private final List<StreamEventHandler> handlers = new ArrayList<StreamEventHandler>();
    private final StreamCoordinator coordinator;
    private boolean flushBeforeTransfer = true;

    public StreamPlan(StreamOperation streamOperation) {
        this(streamOperation, 1, false, ActiveRepairService.NO_PENDING_REPAIR, PreviewKind.NONE);
    }

    public StreamPlan(StreamOperation streamOperation, boolean connectSequentially) {
        this(streamOperation, 1, connectSequentially, ActiveRepairService.NO_PENDING_REPAIR, PreviewKind.NONE);
    }

    public StreamPlan(StreamOperation streamOperation, int connectionsPerHost, boolean connectSequentially, TimeUUID pendingRepair, PreviewKind previewKind) {
        this.streamOperation = streamOperation;
        this.coordinator = new StreamCoordinator(streamOperation, connectionsPerHost, StreamingChannel.Factory.Global.streamingFactory(), false, connectSequentially, pendingRepair, previewKind);
    }

    public StreamPlan requestRanges(InetAddressAndPort from, String keyspace, RangesAtEndpoint fullRanges, RangesAtEndpoint transientRanges) {
        return this.requestRanges(from, keyspace, fullRanges, transientRanges, EMPTY_COLUMN_FAMILIES);
    }

    public StreamPlan requestRanges(InetAddressAndPort from, String keyspace, RangesAtEndpoint fullRanges, RangesAtEndpoint transientRanges, String ... columnFamilies) {
        assert (Iterables.all(fullRanges, Replica::isSelf) || RangesAtEndpoint.isDummyList(fullRanges)) : fullRanges.toString();
        assert (Iterables.all(transientRanges, Replica::isSelf) || RangesAtEndpoint.isDummyList(transientRanges)) : transientRanges.toString();
        StreamSession session = this.coordinator.getOrCreateOutboundSession(from);
        session.addStreamRequest(keyspace, fullRanges, transientRanges, Arrays.asList(columnFamilies));
        return this;
    }

    public StreamPlan transferRanges(InetAddressAndPort to, String keyspace, RangesAtEndpoint replicas, String ... columnFamilies) {
        StreamSession session = this.coordinator.getOrCreateOutboundSession(to);
        session.addTransferRanges(keyspace, replicas, Arrays.asList(columnFamilies), this.flushBeforeTransfer);
        return this;
    }

    public StreamPlan transferStreams(InetAddressAndPort to, Collection<OutgoingStream> streams) {
        this.coordinator.transferStreams(to, streams);
        return this;
    }

    public StreamPlan listeners(StreamEventHandler handler, StreamEventHandler ... handlers) {
        this.handlers.add(handler);
        if (handlers != null) {
            Collections.addAll(this.handlers, handlers);
        }
        return this;
    }

    public TimeUUID planId() {
        return this.planId;
    }

    public StreamOperation streamOperation() {
        return this.streamOperation;
    }

    @VisibleForTesting
    public List<StreamEventHandler> handlers() {
        return this.handlers;
    }

    public StreamPlan connectionFactory(StreamingChannel.Factory factory) {
        this.coordinator.setConnectionFactory(factory);
        return this;
    }

    public boolean isEmpty() {
        return !this.coordinator.hasActiveSessions();
    }

    public StreamResultFuture execute() {
        return StreamResultFuture.createInitiator(this.planId, this.streamOperation, this.handlers, this.coordinator);
    }

    public StreamPlan flushBeforeTransfer(boolean flushBeforeTransfer) {
        this.flushBeforeTransfer = flushBeforeTransfer;
        return this;
    }

    public TimeUUID getPendingRepair() {
        return this.coordinator.getPendingRepair();
    }

    public boolean getFlushBeforeTransfer() {
        return this.flushBeforeTransfer;
    }

    @VisibleForTesting
    public StreamCoordinator getCoordinator() {
        return this.coordinator;
    }
}

