/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.v1;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPaxosVerbHandler
implements IVerbHandler<Commit> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPaxosVerbHandler.class);
    private static final String logMessageTemplate = "Receiving Paxos operation(s) for token(s) neither owned nor pending. Example: from {} for token {} in {}.{}";

    @Override
    public void doVerb(Message<Commit> message) {
        boolean outOfRangeTokenLogging = DatabaseDescriptor.getLogOutOfTokenRangeRequests();
        boolean outOfRangeTokenRejection = DatabaseDescriptor.getRejectOutOfTokenRangeRequests();
        Commit commit = (Commit)message.payload;
        DecoratedKey key = commit.update.partitionKey();
        boolean isOutOfRangeCommit = AbstractPaxosVerbHandler.isOutOfRangeCommit(commit.update.metadata().keyspace, key);
        if (isOutOfRangeCommit) {
            StorageService.instance.incOutOfRangeOperationCount();
            Keyspace.open((String)commit.update.metadata().keyspace).metric.outOfRangeTokenPaxosRequests.inc();
            if (outOfRangeTokenLogging) {
                NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.SECONDS, logMessageTemplate, message.from(), key.getToken(), commit.update.metadata().keyspace, commit.update.metadata().name);
            }
        }
        if (outOfRangeTokenRejection && isOutOfRangeCommit) {
            AbstractPaxosVerbHandler.sendFailureResponse(message);
        } else {
            this.processMessage(message);
        }
    }

    abstract void processMessage(Message<Commit> var1);

    private static void sendFailureResponse(Message<?> respondTo) {
        Message<RequestFailureReason> reply = respondTo.failureResponse(RequestFailureReason.UNKNOWN);
        MessagingService.instance().send(reply, respondTo.from());
    }

    private static boolean isOutOfRangeCommit(String keyspace, DecoratedKey key) {
        return !StorageService.instance.isEndpointValidForWrite(keyspace, key.getToken());
    }
}

