/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.marshal.ValueComparators;
import org.apache.cassandra.serializers.AbstractMapSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.Pair;

public class MapSerializer<K, V>
extends AbstractMapSerializer<Map<K, V>> {
    private static final ConcurrentMap<Pair<TypeSerializer<?>, TypeSerializer<?>>, MapSerializer> instances = new ConcurrentHashMap();
    public final TypeSerializer<K> keys;
    public final TypeSerializer<V> values;
    private final ValueComparators comparators;

    public static <K, V> MapSerializer<K, V> getInstance(TypeSerializer<K> keys, TypeSerializer<V> values, ValueComparators comparators) {
        Pair<TypeSerializer<K>, TypeSerializer<V>> p = Pair.create(keys, values);
        MapSerializer t2 = (MapSerializer)instances.get(p);
        if (t2 == null) {
            t2 = instances.computeIfAbsent(p, k -> new MapSerializer((TypeSerializer)k.left, (TypeSerializer)k.right, comparators));
        }
        return t2;
    }

    private MapSerializer(TypeSerializer<K> keys, TypeSerializer<V> values, ValueComparators comparators) {
        super(true);
        this.keys = keys;
        this.values = values;
        this.comparators = comparators;
    }

    @Override
    public List<ByteBuffer> serializeValues(Map<K, V> map) {
        ArrayList<Pair<ByteBuffer, ByteBuffer>> pairs = new ArrayList<Pair<ByteBuffer, ByteBuffer>>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            pairs.add(Pair.create(this.keys.serialize(entry.getKey()), this.values.serialize(entry.getValue())));
        }
        pairs.sort((l, r) -> this.comparators.buffer.compare((ByteBuffer)l.left, (ByteBuffer)r.left));
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(pairs.size() * 2);
        for (Pair pair : pairs) {
            buffers.add((ByteBuffer)pair.left);
            buffers.add((ByteBuffer)pair.right);
        }
        return buffers;
    }

    @Override
    public int getElementCount(Map<K, V> value) {
        return value.size();
    }

    @Override
    public <T> void validate(T input, ValueAccessor<T> accessor) {
        if (accessor.isEmpty(input)) {
            throw new MarshalException("Not enough bytes to read a map");
        }
        try {
            if (accessor.isEmpty(input)) {
                return;
            }
            int n = MapSerializer.readCollectionSize(input, accessor);
            int offset = MapSerializer.sizeOfCollectionSize();
            for (int i = 0; i < n; ++i) {
                T key = MapSerializer.readNonNullValue(input, accessor, offset);
                this.keys.validate(key, accessor);
                T value = MapSerializer.readNonNullValue(input, accessor, offset += MapSerializer.sizeOfValue(key, accessor));
                offset += MapSerializer.sizeOfValue(value, accessor);
                this.values.validate(value, accessor);
            }
            if (!accessor.isEmptyFromOffset(input, offset)) {
                throw new MarshalException("Unexpected extraneous bytes after map value");
            }
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a map");
        }
    }

    @Override
    public <I> Map<K, V> deserialize(I input, ValueAccessor<I> accessor) {
        try {
            int n = MapSerializer.readCollectionSize(input, accessor);
            int offset = MapSerializer.sizeOfCollectionSize();
            if (n < 0) {
                throw new MarshalException("The data cannot be deserialized as a map");
            }
            LinkedHashMap<K, V> m4 = new LinkedHashMap<K, V>(Math.min(n, 256));
            for (int i = 0; i < n; ++i) {
                I key = MapSerializer.readNonNullValue(input, accessor, offset);
                this.keys.validate(key, accessor);
                I value = MapSerializer.readNonNullValue(input, accessor, offset += MapSerializer.sizeOfValue(key, accessor));
                offset += MapSerializer.sizeOfValue(value, accessor);
                this.values.validate(value, accessor);
                m4.put(this.keys.deserialize(key, accessor), this.values.deserialize(value, accessor));
            }
            if (!accessor.isEmptyFromOffset(input, offset)) {
                throw new MarshalException("Unexpected extraneous bytes after map value");
            }
            return m4;
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a map");
        }
    }

    @Override
    public ByteBuffer getSerializedValue(ByteBuffer collection, ByteBuffer key, AbstractType<?> comparator) {
        try {
            ByteBuffer input = collection.duplicate();
            int n = MapSerializer.readCollectionSize(input, ByteBufferAccessor.instance);
            int offset = MapSerializer.sizeOfCollectionSize();
            for (int i = 0; i < n; ++i) {
                ByteBuffer kbb = MapSerializer.readValue(input, ByteBufferAccessor.instance, offset);
                offset += MapSerializer.sizeOfValue(kbb, ByteBufferAccessor.instance);
                int comparison = comparator.compareForCQL(kbb, key);
                if (comparison == 0) {
                    return MapSerializer.readValue(input, ByteBufferAccessor.instance, offset);
                }
                if (comparison > 0) {
                    return null;
                }
                offset += MapSerializer.skipValue(input, ByteBufferAccessor.instance, offset);
            }
            return null;
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a map");
        }
    }

    @Override
    public String toString(Map<K, V> value) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean isFirst = true;
        for (Map.Entry<K, V> element : value.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.keys.toString(element.getKey()));
            sb.append(": ");
            sb.append(this.values.toString(element.getValue()));
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Class<Map<K, V>> getType() {
        return Map.class;
    }

    @Override
    public void forEach(ByteBuffer input, Consumer<ByteBuffer> action) {
        throw new UnsupportedOperationException();
    }
}

