/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.repair.RepairSessionResult;

public class CoordinatedRepairResult {
    public final Collection<Range<Token>> successfulRanges;
    public final Collection<Range<Token>> failedRanges;
    public final Collection<Range<Token>> skippedRanges;
    public final Optional<List<RepairSessionResult>> results;

    public CoordinatedRepairResult(Collection<Range<Token>> successfulRanges, Collection<Range<Token>> failedRanges, Collection<Range<Token>> skippedRanges, List<RepairSessionResult> results) {
        this.successfulRanges = successfulRanges != null ? ImmutableList.copyOf(successfulRanges) : Collections.emptyList();
        this.failedRanges = failedRanges != null ? ImmutableList.copyOf(failedRanges) : Collections.emptyList();
        this.skippedRanges = skippedRanges != null ? ImmutableList.copyOf(skippedRanges) : Collections.emptyList();
        this.results = Optional.ofNullable(results);
    }

    public static CoordinatedRepairResult create(List<Collection<Range<Token>>> ranges, List<RepairSessionResult> results) {
        if (results == null || results.isEmpty()) {
            return CoordinatedRepairResult.failed(ranges);
        }
        assert (ranges.size() == results.size()) : String.format("range size %d != results size %d;ranges: %s, results: %s", ranges.size(), results.size(), ranges, results);
        ArrayList<Range<Token>> successfulRanges = new ArrayList<Range<Token>>();
        ArrayList<Range<Token>> failedRanges = new ArrayList<Range<Token>>();
        ArrayList<Range<Token>> skippedRanges = new ArrayList<Range<Token>>();
        int index = 0;
        for (RepairSessionResult sessionResult : results) {
            if (sessionResult != null) {
                ArrayList<Range<Token>> replicas = sessionResult.skippedReplicas ? skippedRanges : successfulRanges;
                replicas.addAll(sessionResult.ranges);
            } else {
                failedRanges.addAll(Objects.requireNonNull(ranges.get(index)));
            }
            ++index;
        }
        return new CoordinatedRepairResult(successfulRanges, failedRanges, skippedRanges, results);
    }

    private static CoordinatedRepairResult failed(@Nullable List<Collection<Range<Token>>> ranges) {
        ArrayList<Range<Token>> failedRanges = new ArrayList<Range<Token>>(ranges == null ? 0 : ranges.size());
        if (ranges != null) {
            ranges.forEach(failedRanges::addAll);
        }
        return new CoordinatedRepairResult(null, failedRanges, null, null);
    }

    @VisibleForTesting
    public static CoordinatedRepairResult success(List<RepairSessionResult> results) {
        assert (results != null && results.stream().allMatch(a -> a != null)) : String.format("results was null or had a null (failed) result: %s", results);
        List<Collection<Range<Token>>> ranges = Lists.transform(results, a -> a.ranges);
        return CoordinatedRepairResult.create(ranges, results);
    }

    public boolean hasFailed() {
        return !this.failedRanges.isEmpty();
    }
}

