/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.net.UnknownHostException;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.MessagingService;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointMessagingVersions {
    public volatile int minClusterVersion = MessagingService.current_version;
    private static final Logger logger = LoggerFactory.getLogger(EndpointMessagingVersions.class);
    private final ConcurrentMap<InetAddressAndPort, Integer> versions = new NonBlockingHashMap<InetAddressAndPort, Integer>();

    public int set(InetAddressAndPort endpoint, int version) {
        logger.trace("Setting version {} for {}", (Object)version, (Object)endpoint);
        Integer v = this.versions.put(endpoint, version);
        this.minClusterVersion = (Integer)Collections.min(this.versions.values());
        return v == null ? version : v;
    }

    public void reset(InetAddressAndPort endpoint) {
        logger.trace("Resetting version for {}", (Object)endpoint);
        this.versions.remove(endpoint);
        if (!this.versions.values().isEmpty()) {
            this.minClusterVersion = (Integer)Collections.min(this.versions.values());
        }
    }

    public int get(InetAddressAndPort endpoint) {
        Integer v = (Integer)this.versions.get(endpoint);
        if (v == null) {
            logger.trace("Assuming current protocol version for {}", (Object)endpoint);
            return MessagingService.current_version;
        }
        return Math.min(v, MessagingService.current_version);
    }

    public int get(String endpoint) throws UnknownHostException {
        return this.get(InetAddressAndPort.getByName(endpoint));
    }

    public int getRaw(InetAddressAndPort endpoint) {
        Integer v = (Integer)this.versions.get(endpoint);
        if (v == null) {
            throw new IllegalStateException("getRawVersion() was called without checking knowsVersion() result first");
        }
        return v;
    }

    public boolean knows(InetAddressAndPort endpoint) {
        return this.versions.containsKey(endpoint);
    }
}

