/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.io.util.DataOutputStreamPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.UnbufferedDataOutputStreamPlus;
import org.apache.cassandra.utils.FastByteOperations;

public class BufferedDataOutputStreamPlus
extends DataOutputStreamPlus {
    private static final int DEFAULT_BUFFER_SIZE = CassandraRelevantProperties.NIO_DATA_OUTPUT_STREAM_PLUS_BUFFER_SIZE.getInt();
    protected ByteBuffer buffer;

    public BufferedDataOutputStreamPlus(WritableByteChannel wbc) {
        this(wbc, DEFAULT_BUFFER_SIZE);
    }

    public BufferedDataOutputStreamPlus(WritableByteChannel wbc, int bufferSize) {
        this(wbc, ByteBuffer.allocateDirect(bufferSize));
        Preconditions.checkNotNull(wbc);
        Preconditions.checkArgument(bufferSize >= 8, "Buffer size must be large enough to accommodate a long/double");
    }

    @VisibleForTesting
    public BufferedDataOutputStreamPlus(WritableByteChannel channel, ByteBuffer buffer) {
        super(channel);
        this.buffer = buffer;
    }

    protected BufferedDataOutputStreamPlus(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    protected BufferedDataOutputStreamPlus(int size) {
        this.buffer = this.allocate(size);
    }

    protected ByteBuffer allocate(int size) {
        return ByteBuffer.allocate(size);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        assert (this.buffer != null) : "Attempt to use a closed data output";
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int copied = 0;
        while (copied < len) {
            if (this.buffer.hasRemaining()) {
                int toCopy = Math.min(len - copied, this.buffer.remaining());
                this.buffer.put(b, off + copied, toCopy);
                copied += toCopy;
                continue;
            }
            this.doFlush(len - copied);
        }
    }

    @Override
    public void write(ByteBuffer src) throws IOException {
        int trgAvailable;
        int srcCount;
        assert (this.buffer != null) : "Attempt to use a closed data output";
        int srcPos = src.position();
        while ((srcCount = src.limit() - srcPos) > (trgAvailable = this.buffer.remaining())) {
            FastByteOperations.copy(src, srcPos, this.buffer, this.buffer.position(), trgAvailable);
            this.buffer.position(this.buffer.position() + trgAvailable);
            this.doFlush(src.limit() - (srcPos += trgAvailable));
        }
        FastByteOperations.copy(src, srcPos, this.buffer, this.buffer.position(), srcCount);
        this.buffer.position(this.buffer.position() + srcCount);
    }

    @Override
    public void write(int b) throws IOException {
        assert (this.buffer != null) : "Attempt to use a closed data output";
        if (!this.buffer.hasRemaining()) {
            this.doFlush(1);
        }
        this.buffer.put((byte)(b & 0xFF));
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        assert (this.buffer != null) : "Attempt to use a closed data output";
        if (!this.buffer.hasRemaining()) {
            this.doFlush(1);
        }
        this.buffer.put(v ? (byte)1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeMostSignificantBytes(long register, int bytes) throws IOException {
        assert (this.buffer != null) : "Attempt to use a closed data output";
        if (this.buffer.remaining() < 8) {
            super.writeMostSignificantBytes(register, bytes);
        } else {
            int pos = this.buffer.position();
            this.buffer.putLong(pos, register);
            this.buffer.position(pos + bytes);
        }
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.writeChar(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        assert (this.buffer != null) : "Attempt to use a closed data output";
        if (this.buffer.remaining() < 2) {
            this.writeSlow(v, 2);
        } else {
            this.buffer.putChar((char)v);
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        assert (this.buffer != null) : "Attempt to use a closed data output";
        if (this.buffer.remaining() < 4) {
            this.writeSlow(v, 4);
        } else {
            this.buffer.putInt(v);
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        assert (this.buffer != null) : "Attempt to use a closed data output";
        if (this.buffer.remaining() < 8) {
            this.writeSlow(v, 8);
        } else {
            this.buffer.putLong(v);
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToRawIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(v));
    }

    private void writeSlow(long bytes, int count) throws IOException {
        assert (this.buffer != null) : "Attempt to use a closed data output";
        int origCount = count;
        if (ByteOrder.BIG_ENDIAN == this.buffer.order()) {
            while (count > 0) {
                this.writeByte((int)(bytes >>> 8 * --count));
            }
        } else {
            while (count > 0) {
                this.writeByte((int)(bytes >>> 8 * (origCount - count--)));
            }
        }
    }

    @Override
    public void writeBytes(String s2) throws IOException {
        for (int index = 0; index < s2.length(); ++index) {
            this.writeByte(s2.charAt(index));
        }
    }

    @Override
    public void writeChars(String s2) throws IOException {
        for (int index = 0; index < s2.length(); ++index) {
            this.writeChar(s2.charAt(index));
        }
    }

    @Override
    public void writeUTF(String s2) throws IOException {
        assert (this.buffer != null) : "Attempt to use a closed data output";
        UnbufferedDataOutputStreamPlus.writeUTF(s2, this);
    }

    protected void doFlush(int count) throws IOException {
        assert (this.buffer != null) : "Attempt to use a closed data output";
        this.buffer.flip();
        while (this.buffer.hasRemaining()) {
            this.channel.write(this.buffer);
        }
        this.buffer.clear();
    }

    @Override
    public void flush() throws IOException {
        this.doFlush(0);
    }

    @Override
    public void close() throws IOException {
        if (this.buffer == null) {
            return;
        }
        this.doFlush(0);
        this.channel.close();
        FileUtils.clean(this.buffer);
        this.buffer = null;
    }

    public BufferedDataOutputStreamPlus order(ByteOrder order) {
        assert (this.buffer != null) : "Attempt to use a closed data output";
        this.buffer.order(order);
        return this;
    }
}

