/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.collect.ImmutableSet;
import java.io.IOError;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.schema.TableMetadata;

public class SSTableSimpleScanner
implements ISSTableScanner {
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final RandomAccessReader dfile;
    private final SSTableReader sstable;
    private final Iterator<SSTableReader.PartitionPositionBounds> rangeIterator;
    private long bytesScannedInPreviousRanges;
    private final long sizeInBytes;
    private final long compressedSizeInBytes;
    private long currentEndPosition;
    private long currentStartPosition;
    private SSTableIdentityIterator currentIterator;
    private DecoratedKey lastKey;

    public SSTableSimpleScanner(SSTableReader sstable, Collection<SSTableReader.PartitionPositionBounds> boundsList) {
        assert (sstable != null);
        this.dfile = sstable.openDataReaderForScan();
        this.sstable = sstable;
        this.sizeInBytes = boundsList.stream().mapToLong(ppb -> ppb.upperPosition - ppb.lowerPosition).sum();
        this.compressedSizeInBytes = sstable.compression ? sstable.onDiskSizeForPartitionPositions(boundsList) : this.sizeInBytes;
        this.rangeIterator = boundsList.iterator();
        this.currentEndPosition = 0L;
        this.currentStartPosition = 0L;
        this.bytesScannedInPreviousRanges = 0L;
        this.currentIterator = null;
        this.lastKey = null;
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.bytesScannedInPreviousRanges += this.dfile.getFilePointer() - this.currentStartPosition;
            this.dfile.close();
            this.currentStartPosition = this.dfile.getFilePointer();
        }
    }

    @Override
    public long getLengthInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public long getCompressedLengthInBytes() {
        return this.compressedSizeInBytes;
    }

    @Override
    public long getCurrentPosition() {
        return this.dfile.getFilePointer();
    }

    @Override
    public long getBytesScanned() {
        return this.bytesScannedInPreviousRanges + this.dfile.getFilePointer() - this.currentStartPosition;
    }

    @Override
    public Set<SSTableReader> getBackingSSTables() {
        return ImmutableSet.of(this.sstable);
    }

    @Override
    public TableMetadata metadata() {
        return this.sstable.metadata();
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator != null) {
            this.currentIterator.close();
            this.currentIterator.exhaust();
            this.currentIterator = null;
        }
        if (this.dfile.getFilePointer() < this.currentEndPosition) {
            return true;
        }
        return this.advanceRange();
    }

    boolean advanceRange() {
        try {
            if (!this.rangeIterator.hasNext()) {
                return false;
            }
            this.bytesScannedInPreviousRanges += this.currentEndPosition - this.currentStartPosition;
            SSTableReader.PartitionPositionBounds nextRange = this.rangeIterator.next();
            if (this.currentEndPosition > nextRange.lowerPosition) {
                throw new IllegalArgumentException("Ranges supplied to SSTableSimpleScanner must be non-overlapping and in ascending order.");
            }
            this.currentEndPosition = nextRange.upperPosition;
            this.currentStartPosition = nextRange.lowerPosition;
            this.dfile.seek(this.currentStartPosition);
            return true;
        }
        catch (CorruptSSTableException e) {
            this.sstable.markSuspect();
            throw e;
        }
        catch (IOError e) {
            if (e.getCause() instanceof IOException) {
                this.sstable.markSuspect();
                throw new CorruptSSTableException((Throwable)((Exception)e.getCause()), this.sstable.getFilename());
            }
            throw e;
        }
    }

    @Override
    public UnfilteredRowIterator next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentIterator = SSTableIdentityIterator.create(this.sstable, (FileDataInput)this.dfile, false);
        DecoratedKey currentKey = this.currentIterator.partitionKey();
        if (this.lastKey != null && this.lastKey.compareTo(currentKey) >= 0) {
            this.sstable.markSuspect();
            throw new CorruptSSTableException((Throwable)new IllegalStateException(String.format("Invalid key order: current %s <= previous %s", currentKey, this.lastKey)), this.sstable.getFilename());
        }
        this.lastKey = currentKey;
        return this.currentIterator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format("%s(sstable=%s)", this.getClass().getSimpleName(), this.sstable);
    }
}

