/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.memory;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.memory.MemtableIndex;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;

public class MemtableIndexManager {
    private final StorageAttachedIndex index;
    private final ConcurrentMap<Memtable, MemtableIndex> liveMemtableIndexMap;

    public MemtableIndexManager(StorageAttachedIndex index) {
        this.index = index;
        this.liveMemtableIndexMap = new ConcurrentHashMap<Memtable, MemtableIndex>();
    }

    public long index(DecoratedKey key, Row row, Memtable mt) {
        MemtableIndex current = (MemtableIndex)this.liveMemtableIndexMap.get(mt);
        MemtableIndex target = current != null ? current : this.liveMemtableIndexMap.computeIfAbsent(mt, memtable -> new MemtableIndex(this.index));
        long start = Clock.Global.nanoTime();
        long bytes = 0L;
        if (this.index.termType().isNonFrozenCollection()) {
            Iterator<ByteBuffer> bufferIterator = this.index.termType().valuesOf(row, FBUtilities.nowInSeconds());
            if (bufferIterator != null) {
                while (bufferIterator.hasNext()) {
                    ByteBuffer value = bufferIterator.next();
                    bytes += target.index(key, (Clustering<?>)row.clustering(), value);
                }
            }
        } else {
            ByteBuffer value = this.index.termType().valueOf(key, row, FBUtilities.nowInSeconds());
            bytes += target.index(key, (Clustering<?>)row.clustering(), value);
        }
        this.index.indexMetrics().memtableIndexWriteLatency.update(Clock.Global.nanoTime() - start, TimeUnit.NANOSECONDS);
        return bytes;
    }

    public long update(DecoratedKey key, Row oldRow, Row newRow, Memtable memtable) {
        if (!this.index.termType().isVector()) {
            return this.index(key, newRow, memtable);
        }
        MemtableIndex target = (MemtableIndex)this.liveMemtableIndexMap.get(memtable);
        if (target == null) {
            return 0L;
        }
        ByteBuffer oldValue = this.index.termType().valueOf(key, oldRow, FBUtilities.nowInSeconds());
        ByteBuffer newValue = this.index.termType().valueOf(key, newRow, FBUtilities.nowInSeconds());
        return target.update(key, (Clustering<?>)oldRow.clustering(), oldValue, newValue);
    }

    public void renewMemtable(Memtable renewed) {
        for (Memtable memtable : this.liveMemtableIndexMap.keySet()) {
            if (renewed == memtable) continue;
            this.liveMemtableIndexMap.remove(memtable);
        }
    }

    public void discardMemtable(Memtable discarded) {
        this.liveMemtableIndexMap.remove(discarded);
    }

    @Nullable
    public MemtableIndex getPendingMemtableIndex(LifecycleNewTracker tracker) {
        return this.liveMemtableIndexMap.keySet().stream().filter(m4 -> tracker.equals(m4.getFlushTransaction())).findFirst().map(this.liveMemtableIndexMap::get).orElse(null);
    }

    public long liveMemtableWriteCount() {
        return this.liveMemtableIndexMap.values().stream().mapToLong(MemtableIndex::writeCount).sum();
    }

    public Collection<MemtableIndex> getLiveMemtableIndexesSnapshot() {
        Collection memtableIndexes = this.liveMemtableIndexMap.values();
        if (memtableIndexes.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<MemtableIndex>(memtableIndexes);
    }

    public long estimatedMemIndexMemoryUsed() {
        return this.liveMemtableIndexMap.values().stream().mapToLong(MemtableIndex::estimatedMemoryUsed).sum();
    }

    @VisibleForTesting
    public int size() {
        return this.liveMemtableIndexMap.size();
    }

    public void invalidate() {
        this.liveMemtableIndexMap.clear();
    }
}

