/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai;

import com.google.common.base.Objects;
import java.util.Collections;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.disk.PrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.SharedCloseableImpl;

public class SSTableContext
extends SharedCloseableImpl {
    public final SSTableReader sstable;
    public final IndexDescriptor indexDescriptor;
    public final PrimaryKeyMap.Factory primaryKeyMapFactory;

    private SSTableContext(SSTableReader sstable, IndexDescriptor indexDescriptor, PrimaryKeyMap.Factory primaryKeyMapFactory, Cleanup cleanup) {
        super(cleanup);
        this.sstable = sstable;
        this.indexDescriptor = indexDescriptor;
        this.primaryKeyMapFactory = primaryKeyMapFactory;
    }

    private SSTableContext(SSTableContext copy) {
        super(copy);
        this.sstable = copy.sstable;
        this.indexDescriptor = copy.indexDescriptor;
        this.primaryKeyMapFactory = copy.primaryKeyMapFactory;
    }

    public static SSTableContext create(SSTableReader sstable) {
        Ref<SSTableReader> sstableRef = null;
        PrimaryKeyMap.Factory primaryKeyMapFactory = null;
        IndexDescriptor indexDescriptor = IndexDescriptor.create(sstable);
        try {
            sstableRef = sstable.tryRef();
            if (sstableRef == null) {
                throw new IllegalStateException("Couldn't acquire reference to the sstable: " + sstable);
            }
            primaryKeyMapFactory = indexDescriptor.newPrimaryKeyMapFactory(sstable);
            Cleanup cleanup = new Cleanup(primaryKeyMapFactory, indexDescriptor, sstableRef);
            return new SSTableContext(sstable, indexDescriptor, primaryKeyMapFactory, cleanup);
        }
        catch (Throwable t2) {
            if (sstableRef != null) {
                sstableRef.release();
            }
            throw Throwables.unchecked(Throwables.close(t2, Collections.singleton(primaryKeyMapFactory)));
        }
    }

    @Override
    public SSTableContext sharedCopy() {
        return new SSTableContext(this);
    }

    public SSTableIndex newSSTableIndex(StorageAttachedIndex index) {
        return this.indexDescriptor.newSSTableIndex(this, index);
    }

    public Descriptor descriptor() {
        return this.sstable.descriptor;
    }

    public long diskUsage() {
        return this.indexDescriptor.sizeOnDiskOfPerSSTableComponents();
    }

    public int openFilesPerSSTable() {
        return this.indexDescriptor.version.onDiskFormat().openFilesPerSSTableIndex(this.indexDescriptor.hasClustering());
    }

    public String toString() {
        return "SSTableContext{sstable=" + this.sstable.descriptor + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SSTableContext that = (SSTableContext)o;
        return Objects.equal(this.sstable.descriptor, that.sstable.descriptor);
    }

    public int hashCode() {
        return Objects.hashCode(this.sstable.descriptor.hashCode());
    }

    private static class Cleanup
    implements RefCounted.Tidy {
        private final PrimaryKeyMap.Factory primaryKeyMapFactory;
        private final IndexDescriptor indexDescriptor;
        private final Ref<? extends SSTableReader> sstableRef;

        private Cleanup(PrimaryKeyMap.Factory primaryKeyMapFactory, IndexDescriptor indexDescriptor, Ref<? extends SSTableReader> sstableRef) {
            this.primaryKeyMapFactory = primaryKeyMapFactory;
            this.indexDescriptor = indexDescriptor;
            this.sstableRef = sstableRef;
        }

        @Override
        public void tidy() {
            Throwable t2 = this.sstableRef.ensureReleased(null);
            t2 = Throwables.close(t2, Collections.singleton(this.primaryKeyMapFactory));
            Throwables.maybeFail(t2);
        }

        @Override
        public String name() {
            return this.indexDescriptor.toString();
        }
    }
}

