/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.hints.HintsDescriptor;
import org.apache.cassandra.hints.HintsStore;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.NativeLibrary;
import org.apache.cassandra.utils.SyncUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HintsCatalog {
    private static final Logger logger = LoggerFactory.getLogger(HintsCatalog.class);
    private final File hintsDirectory;
    private final Map<UUID, HintsStore> stores;
    private final ImmutableMap<String, Object> writerParams;

    private HintsCatalog(File hintsDirectory, ImmutableMap<String, Object> writerParams, Map<UUID, List<HintsDescriptor>> descriptors) {
        this.hintsDirectory = hintsDirectory;
        this.writerParams = writerParams;
        this.stores = new ConcurrentHashMap<UUID, HintsStore>();
        for (Map.Entry<UUID, List<HintsDescriptor>> entry : descriptors.entrySet()) {
            this.stores.put(entry.getKey(), HintsStore.create(entry.getKey(), hintsDirectory, writerParams, entry.getValue()));
        }
    }

    static HintsCatalog load(File hintsDirectory, ImmutableMap<String, Object> writerParams) {
        HintsCatalog hintsCatalog;
        block8: {
            Stream<Path> list = Files.list(hintsDirectory.toPath());
            try {
                Map<UUID, List<HintsDescriptor>> stores = list.filter(HintsDescriptor::isHintFileName).map(HintsDescriptor::readFromFileQuietly).filter(Optional::isPresent).map(Optional::get).collect(Collectors.groupingBy(h2 -> h2.hostId));
                hintsCatalog = new HintsCatalog(hintsDirectory, writerParams, stores);
                if (list == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (list != null) {
                        try {
                            list.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FSReadError((Throwable)e, hintsDirectory);
                }
            }
            list.close();
        }
        return hintsCatalog;
    }

    Stream<HintsStore> stores() {
        return this.stores.values().stream();
    }

    void maybeLoadStores(Iterable<UUID> hostIds) {
        for (UUID hostId : hostIds) {
            this.get(hostId);
        }
    }

    HintsStore get(UUID hostId) {
        HintsStore store = this.stores.get(hostId);
        return store == null ? this.stores.computeIfAbsent(hostId, id -> HintsStore.create(id, this.hintsDirectory, this.writerParams, Collections.emptyList())) : store;
    }

    @Nullable
    HintsStore getNullable(UUID hostId) {
        return this.stores.get(hostId);
    }

    void deleteAllHints() {
        this.stores.keySet().forEach(this::deleteAllHints);
    }

    void deleteAllHints(UUID hostId) {
        HintsStore store = this.stores.get(hostId);
        if (store != null) {
            store.deleteAllHints();
        }
    }

    boolean hasFiles() {
        return this.stores().anyMatch(HintsStore::hasFiles);
    }

    void exciseStore(UUID hostId) {
        this.deleteAllHints(hostId);
        this.stores.remove(hostId);
    }

    void fsyncDirectory() {
        int fd = NativeLibrary.tryOpenDirectory(this.hintsDirectory.absolutePath());
        if (fd != -1) {
            try {
                SyncUtil.trySync(fd);
                NativeLibrary.tryCloseFD(fd);
            }
            catch (FSError e) {
                logger.error("Unable to sync directory {}", (Object)this.hintsDirectory.absolutePath(), (Object)e);
                FileUtils.handleFSErrorAndPropagate(e);
            }
        } else if (DatabaseDescriptor.isClientInitialized()) {
            logger.warn("Unable to open hint directory using Native library. Skipping sync.");
        } else {
            if (SyncUtil.SKIP_SYNC) {
                return;
            }
            logger.error("Unable to open directory {}", (Object)this.hintsDirectory.absolutePath());
            FileUtils.handleFSErrorAndPropagate(new FSWriteError((Throwable)new IOException(String.format("Unable to open hint directory %s", this.hintsDirectory.absolutePath())), this.hintsDirectory.absolutePath()));
        }
    }

    ImmutableMap<String, Object> getWriterParams() {
        return this.writerParams;
    }
}

