/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.NavigableSet;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.MutableDeletionInfo;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.BTreePartitionData;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.AbstractUnfilteredRowIterator;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowAndDeletionMergeIterator;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.SearchIterator;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.BTreeSearchIterator;

public abstract class AbstractBTreePartition
implements Partition,
Iterable<Row> {
    protected final DecoratedKey partitionKey;

    protected abstract BTreePartitionData holder();

    protected abstract boolean canHaveShadowedData();

    protected AbstractBTreePartition(DecoratedKey partitionKey) {
        this.partitionKey = partitionKey;
    }

    public DeletionInfo deletionInfo() {
        return this.holder().deletionInfo;
    }

    public Row staticRow() {
        return this.holder().staticRow;
    }

    @Override
    public boolean isEmpty() {
        BTreePartitionData holder = this.holder();
        return holder.deletionInfo.isLive() && BTree.isEmpty(holder.tree) && holder.staticRow.isEmpty();
    }

    @Override
    public boolean hasRows() {
        BTreePartitionData holder = this.holder();
        return !BTree.isEmpty(holder.tree);
    }

    @Override
    public abstract TableMetadata metadata();

    @Override
    public DecoratedKey partitionKey() {
        return this.partitionKey;
    }

    @Override
    public DeletionTime partitionLevelDeletion() {
        return this.deletionInfo().getPartitionDeletion();
    }

    @Override
    public RegularAndStaticColumns columns() {
        return this.holder().columns;
    }

    @Override
    public EncodingStats stats() {
        return this.holder().stats;
    }

    @Override
    public Row getRow(Clustering<?> clustering) {
        ColumnFilter columns = ColumnFilter.selection(this.columns());
        BTreePartitionData holder = this.holder();
        if (clustering == Clustering.STATIC_CLUSTERING) {
            Row staticRow = this.staticRow(holder, columns, true);
            return staticRow.isEmpty() ? null : staticRow;
        }
        Row row = (Row)((Object)BTree.find(holder.tree, this.metadata().comparator, clustering));
        DeletionTime activeDeletion = holder.deletionInfo.getPartitionDeletion();
        RangeTombstone rt = holder.deletionInfo.rangeCovering(clustering);
        if (rt != null && rt.deletionTime().supersedes(activeDeletion)) {
            activeDeletion = rt.deletionTime();
        }
        if (row == null) {
            if (activeDeletion == holder.deletionInfo.getPartitionDeletion()) {
                return null;
            }
            return BTreeRow.emptyDeletedRow(clustering, Row.Deletion.regular(activeDeletion));
        }
        return row.filter(columns, activeDeletion, true, this.metadata());
    }

    private Row staticRow(BTreePartitionData current, ColumnFilter columns, boolean setActiveDeletionToRow) {
        DeletionTime partitionDeletion = current.deletionInfo.getPartitionDeletion();
        if (columns.fetchedColumns().statics.isEmpty() || current.staticRow.isEmpty() && partitionDeletion.isLive()) {
            return Rows.EMPTY_STATIC_ROW;
        }
        Row row = current.staticRow.filter(columns, partitionDeletion, setActiveDeletionToRow, this.metadata());
        return row == null ? Rows.EMPTY_STATIC_ROW : row;
    }

    @Override
    public UnfilteredRowIterator unfilteredIterator(ColumnFilter selection, NavigableSet<Clustering<?>> clusteringsInQueryOrder, boolean reversed) {
        Row staticRow = this.staticRow(this.holder(), selection, false);
        if (clusteringsInQueryOrder.isEmpty()) {
            DeletionTime partitionDeletion = this.holder().deletionInfo.getPartitionDeletion();
            return UnfilteredRowIterators.noRowsIterator(this.metadata(), this.partitionKey(), staticRow, partitionDeletion, reversed);
        }
        return new ClusteringsIterator(selection, clusteringsInQueryOrder, reversed, this.holder(), staticRow);
    }

    @Override
    public UnfilteredRowIterator unfilteredIterator() {
        return this.unfilteredIterator(ColumnFilter.selection(this.columns()), Slices.ALL, false);
    }

    @Override
    public UnfilteredRowIterator unfilteredIterator(ColumnFilter selection, Slices slices, boolean reversed) {
        return this.unfilteredIterator(this.holder(), selection, slices, reversed);
    }

    public UnfilteredRowIterator unfilteredIterator(BTreePartitionData current, ColumnFilter selection, Slices slices, boolean reversed) {
        Row staticRow = this.staticRow(current, selection, false);
        if (slices.size() == 0) {
            DeletionTime partitionDeletion = current.deletionInfo.getPartitionDeletion();
            return UnfilteredRowIterators.noRowsIterator(this.metadata(), this.partitionKey(), staticRow, partitionDeletion, reversed);
        }
        return slices.size() == 1 ? this.sliceIterator(selection, slices.get(0), reversed, current, staticRow) : new SlicesIterator(selection, slices, reversed, current, staticRow);
    }

    private UnfilteredRowIterator sliceIterator(ColumnFilter selection, Slice slice, boolean reversed, BTreePartitionData current, Row staticRow) {
        ClusteringBound<?> start = slice.start().isBottom() ? null : slice.start();
        ClusteringBound<?> end = slice.end().isTop() ? null : slice.end();
        BTreeSearchIterator rowIter = BTree.slice(current.tree, this.metadata().comparator, start, true, end, true, BTree.Dir.desc(reversed));
        Iterator<RangeTombstone> deleteIter = current.deletionInfo.rangeIterator(slice, reversed);
        return this.merge(rowIter, deleteIter, selection, reversed, current, staticRow);
    }

    private RowAndDeletionMergeIterator merge(Iterator<Row> rowIter, Iterator<RangeTombstone> deleteIter, ColumnFilter selection, boolean reversed, BTreePartitionData current, Row staticRow) {
        return new RowAndDeletionMergeIterator(this.metadata(), this.partitionKey(), current.deletionInfo.getPartitionDeletion(), selection, staticRow, reversed, current.stats, rowIter, deleteIter, this.canHaveShadowedData());
    }

    protected static BTreePartitionData build(UnfilteredRowIterator iterator, int initialRowCapacity) {
        return AbstractBTreePartition.build(iterator, initialRowCapacity, true);
    }

    protected static BTreePartitionData build(UnfilteredRowIterator iterator, int initialRowCapacity, boolean ordered) {
        TableMetadata metadata = iterator.metadata();
        RegularAndStaticColumns columns = iterator.columns();
        boolean reversed = iterator.isReverseOrder();
        BTree.Builder<Clusterable> builder = BTree.builder(metadata.comparator, initialRowCapacity);
        builder.auto(!ordered);
        MutableDeletionInfo.Builder deletionBuilder = MutableDeletionInfo.builder(iterator.partitionLevelDeletion(), metadata.comparator, reversed);
        while (iterator.hasNext()) {
            Unfiltered unfiltered = (Unfiltered)iterator.next();
            if (unfiltered.kind() == Unfiltered.Kind.ROW) {
                builder.add((Row)unfiltered);
                continue;
            }
            deletionBuilder.add((RangeTombstoneMarker)unfiltered);
        }
        if (reversed) {
            builder.reverse();
        }
        return new BTreePartitionData(columns, builder.build(), deletionBuilder.build(), iterator.staticRow(), iterator.stats());
    }

    protected static BTreePartitionData build(RowIterator rows, DeletionInfo deletion, boolean buildEncodingStats) {
        RegularAndStaticColumns columns = rows.columns();
        boolean reversed = rows.isReverseOrder();
        try (BTree.FastBuilder<Row> builder = BTree.fastBuilder();){
            while (rows.hasNext()) {
                builder.add((Row)rows.next());
            }
            Object[] tree = reversed ? builder.buildReverse() : builder.build();
            Row staticRow = rows.staticRow();
            EncodingStats stats = buildEncodingStats ? EncodingStats.Collector.collect(staticRow, BTree.iterator(tree), deletion) : EncodingStats.NO_STATS;
            BTreePartitionData bTreePartitionData = new BTreePartitionData(columns, tree, deletion, staticRow, stats);
            return bTreePartitionData;
        }
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeFullDetails) {
        StringBuilder sb = new StringBuilder();
        if (includeFullDetails) {
            sb.append(String.format("[%s.%s] key=%s partition_deletion=%s columns=%s", this.metadata().keyspace, this.metadata().name, this.metadata().partitionKeyType.getString(this.partitionKey().getKey()), this.partitionLevelDeletion(), this.columns()));
        } else {
            sb.append("key=").append(this.metadata().partitionKeyType.getString(this.partitionKey().getKey()));
        }
        if (this.staticRow() != Rows.EMPTY_STATIC_ROW) {
            sb.append("\n    ").append(this.staticRow().toString(this.metadata(), includeFullDetails));
        }
        try (UnfilteredRowIterator iter2 = this.unfilteredIterator();){
            while (iter2.hasNext()) {
                sb.append("\n    ").append(((Unfiltered)iter2.next()).toString(this.metadata(), includeFullDetails));
            }
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PartitionUpdate)) {
            return false;
        }
        PartitionUpdate that = (PartitionUpdate)obj;
        BTreePartitionData a = this.holder();
        BTreePartitionData b = that.holder();
        return this.partitionKey.equals(that.partitionKey) && this.metadata().id.equals(that.metadata().id) && a.deletionInfo.equals(b.deletionInfo) && a.staticRow.equals(b.staticRow) && Iterators.elementsEqual(this.iterator(), that.iterator());
    }

    public int rowCount() {
        return BTree.size(this.holder().tree);
    }

    @Override
    public Iterator<Row> iterator() {
        return BTree.iterator(this.holder().tree);
    }

    public Row lastRow() {
        Object[] tree = this.holder().tree;
        if (BTree.isEmpty(tree)) {
            return null;
        }
        return (Row)BTree.findByIndex(tree, BTree.size(tree) - 1);
    }

    private class ClusteringsIterator
    extends AbstractIterator {
        private final Iterator<Clustering<?>> clusteringsInQueryOrder;
        private final SearchIterator<Clustering<?>, Row> rowSearcher;
        private Iterator<Unfiltered> currentIterator;

        private ClusteringsIterator(ColumnFilter selection, NavigableSet<Clustering<?>> clusteringsInQueryOrder, boolean isReversed, BTreePartitionData current, Row staticRow) {
            super(current, staticRow, selection, isReversed);
            this.clusteringsInQueryOrder = clusteringsInQueryOrder.iterator();
            this.rowSearcher = BTree.slice(current.tree, this.metadata().comparator, BTree.Dir.desc(isReversed));
        }

        @Override
        protected Unfiltered computeNext() {
            while (true) {
                if (this.currentIterator == null) {
                    if (!this.clusteringsInQueryOrder.hasNext()) {
                        return (Unfiltered)this.endOfData();
                    }
                    this.currentIterator = this.nextIterator(this.clusteringsInQueryOrder.next());
                }
                if (this.currentIterator != null && this.currentIterator.hasNext()) {
                    return this.currentIterator.next();
                }
                this.currentIterator = null;
            }
        }

        private Iterator<Unfiltered> nextIterator(Clustering<?> next) {
            Row nextRow = this.rowSearcher.next(next);
            Iterator<RangeTombstone> deleteIter = this.current.deletionInfo.rangeIterator(Slice.make(next), this.isReverseOrder());
            if (nextRow == null && !deleteIter.hasNext()) {
                return null;
            }
            Iterator<Row> rowIterator = nextRow == null ? Collections.emptyIterator() : Iterators.singletonIterator(nextRow);
            return AbstractBTreePartition.this.merge(rowIterator, deleteIter, this.selection, this.isReverseOrder, this.current, this.staticRow);
        }
    }

    private class SlicesIterator
    extends AbstractIterator {
        private final Slices slices;
        private int idx;
        private Iterator<Unfiltered> currentSlice;

        private SlicesIterator(ColumnFilter selection, Slices slices, boolean isReversed, BTreePartitionData current, Row staticRow) {
            super(current, staticRow, selection, isReversed);
            this.slices = slices;
        }

        @Override
        protected Unfiltered computeNext() {
            while (true) {
                if (this.currentSlice == null) {
                    if (this.idx >= this.slices.size()) {
                        return (Unfiltered)this.endOfData();
                    }
                    int sliceIdx = this.isReverseOrder ? this.slices.size() - this.idx - 1 : this.idx;
                    this.currentSlice = AbstractBTreePartition.this.sliceIterator(this.selection, this.slices.get(sliceIdx), this.isReverseOrder, this.current, Rows.EMPTY_STATIC_ROW);
                    ++this.idx;
                }
                if (this.currentSlice.hasNext()) {
                    return this.currentSlice.next();
                }
                this.currentSlice = null;
            }
        }
    }

    private abstract class AbstractIterator
    extends AbstractUnfilteredRowIterator {
        final BTreePartitionData current;
        final ColumnFilter selection;

        private AbstractIterator(BTreePartitionData current, Row staticRow, ColumnFilter selection, boolean isReversed) {
            super(AbstractBTreePartition.this.metadata(), AbstractBTreePartition.this.partitionKey(), current.deletionInfo.getPartitionDeletion(), selection.fetchedColumns(), staticRow, isReversed, current.stats);
            this.current = current;
            this.selection = selection;
        }
    }
}

