/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.commitlog.IntervalSet;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.ShardManager;
import org.apache.cassandra.db.compaction.ShardTracker;
import org.apache.cassandra.db.compaction.unified.Controller;
import org.apache.cassandra.db.compaction.unified.ShardedMultiWriter;
import org.apache.cassandra.db.compaction.unified.UnifiedCompactionTask;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Overlaps;
import org.apache.cassandra.utils.TimeUUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifiedCompactionStrategy
extends AbstractCompactionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UnifiedCompactionStrategy.class);
    static final int MAX_LEVELS = 32;
    private static final Pattern SCALING_PARAMETER_PATTERN = Pattern.compile("(N)|L(\\d+)|T(\\d+)|([+-]?\\d+)");
    private static final String SCALING_PARAMETER_PATTERN_SIMPLIFIED = SCALING_PARAMETER_PATTERN.pattern().replaceAll("[()]", "").replace("\\d", "[0-9]");
    private final Controller controller;
    private volatile ShardManager shardManager;
    private long lastExpiredCheck;
    protected volatile int estimatedRemainingTasks;
    @VisibleForTesting
    protected final Set<SSTableReader> sstables = new HashSet<SSTableReader>();

    public UnifiedCompactionStrategy(ColumnFamilyStore cfs, Map<String, String> options) {
        this(cfs, options, Controller.fromOptions(cfs, options));
    }

    public UnifiedCompactionStrategy(ColumnFamilyStore cfs, Map<String, String> options, Controller controller) {
        super(cfs, options);
        this.controller = controller;
        this.estimatedRemainingTasks = 0;
        this.lastExpiredCheck = Clock.Global.currentTimeMillis();
    }

    public static Map<String, String> validateOptions(Map<String, String> options) throws ConfigurationException {
        return Controller.validateOptions(AbstractCompactionStrategy.validateOptions(options));
    }

    public static int fanoutFromScalingParameter(int w) {
        return w < 0 ? 2 - w : 2 + w;
    }

    public static int thresholdFromScalingParameter(int w) {
        return w <= 0 ? 2 : 2 + w;
    }

    public static int parseScalingParameter(String value) {
        Matcher m4 = SCALING_PARAMETER_PATTERN.matcher(value);
        if (!m4.matches()) {
            throw new ConfigurationException("Scaling parameter " + value + " must match " + SCALING_PARAMETER_PATTERN_SIMPLIFIED);
        }
        if (m4.group(1) != null) {
            return 0;
        }
        if (m4.group(2) != null) {
            return 2 - UnifiedCompactionStrategy.atLeast2(Integer.parseInt(m4.group(2)), value);
        }
        if (m4.group(3) != null) {
            return UnifiedCompactionStrategy.atLeast2(Integer.parseInt(m4.group(3)), value) - 2;
        }
        return Integer.parseInt(m4.group(4));
    }

    private static int atLeast2(int value, String str) {
        if (value < 2) {
            throw new ConfigurationException("Fan factor cannot be lower than 2 in " + str);
        }
        return value;
    }

    public static String printScalingParameter(int w) {
        if (w < 0) {
            return "L" + Integer.toString(2 - w);
        }
        if (w > 0) {
            return "T" + Integer.toString(w + 2);
        }
        return "N";
    }

    @Override
    public synchronized Collection<AbstractCompactionTask> getMaximalTask(long gcBefore, boolean splitOutput) {
        this.maybeUpdateShardManager();
        ArrayList<AbstractCompactionTask> tasks = new ArrayList<AbstractCompactionTask>();
        List<Set<SSTableReader>> nonOverlapping = UnifiedCompactionStrategy.splitInNonOverlappingSets(UnifiedCompactionStrategy.filterSuspectSSTables(this.getSSTables()));
        for (Set<SSTableReader> set : nonOverlapping) {
            LifecycleTransaction txn = this.cfs.getTracker().tryModify(set, OperationType.COMPACTION);
            if (txn == null) continue;
            tasks.add(this.createCompactionTask(txn, gcBefore));
        }
        return tasks;
    }

    private static List<Set<SSTableReader>> splitInNonOverlappingSets(Collection<SSTableReader> sstables) {
        List<Set<SSTableReader>> overlapSets = Overlaps.constructOverlapSets(new ArrayList<SSTableReader>(sstables), UnifiedCompactionStrategy::startsAfter, SSTableReader.firstKeyComparator, SSTableReader.lastKeyComparator);
        if (overlapSets.isEmpty()) {
            return overlapSets;
        }
        Set<SSTableReader> group = overlapSets.get(0);
        ArrayList<Set<SSTableReader>> groups = new ArrayList<Set<SSTableReader>>();
        for (int i = 1; i < overlapSets.size(); ++i) {
            Set<SSTableReader> current = overlapSets.get(i);
            if (Sets.intersection(current, group).isEmpty()) {
                groups.add(group);
                group = current;
                continue;
            }
            group.addAll(current);
        }
        groups.add(group);
        return groups;
    }

    @Override
    public AbstractCompactionTask getUserDefinedTask(Collection<SSTableReader> sstables, long gcBefore) {
        assert (!sstables.isEmpty());
        LifecycleTransaction transaction = this.cfs.getTracker().tryModify(sstables, OperationType.COMPACTION);
        if (transaction == null) {
            logger.trace("Unable to mark {} for compaction; probably a background compaction got to it first.  You can disable background compactions temporarily if this is a problem", sstables);
            return null;
        }
        return this.createCompactionTask(transaction, gcBefore).setUserDefined(true);
    }

    @Override
    public synchronized UnifiedCompactionTask getNextBackgroundTask(long gcBefore) {
        CompactionPick pick;
        UnifiedCompactionTask task;
        do {
            if ((pick = this.getNextCompactionPick(gcBefore)) != null) continue;
            return null;
        } while ((task = this.createCompactionTask(pick, gcBefore)) == null);
        return task;
    }

    private UnifiedCompactionTask createCompactionTask(CompactionPick pick, long gcBefore) {
        Preconditions.checkNotNull(pick);
        Preconditions.checkArgument(!pick.isEmpty());
        LifecycleTransaction transaction = this.cfs.getTracker().tryModify(pick, OperationType.COMPACTION);
        if (transaction != null) {
            return this.createCompactionTask(transaction, gcBefore);
        }
        logger.warn("Failed to submit compaction {} because a transaction could not be created. If this happens frequently, it should be reported", (Object)pick);
        return null;
    }

    @Override
    public SSTableMultiWriter createSSTableMultiWriter(Descriptor descriptor, long keyCount, long repairedAt, TimeUUID pendingRepair, boolean isTransient, IntervalSet<CommitLogPosition> commitLogPositions, int sstableLevel, SerializationHeader header, Collection<Index.Group> indexGroups, LifecycleNewTracker lifecycleNewTracker) {
        ShardManager shardManager = this.getShardManager();
        double flushDensity = this.cfs.metric.flushSizeOnDisk.get() * shardManager.shardSetCoverage() / shardManager.localSpaceCoverage();
        ShardTracker boundaries = shardManager.boundaries(this.controller.getNumShards(flushDensity));
        return new ShardedMultiWriter(this.cfs, descriptor, keyCount, repairedAt, pendingRepair, isTransient, commitLogPositions, header, indexGroups, lifecycleNewTracker, boundaries);
    }

    private UnifiedCompactionTask createCompactionTask(LifecycleTransaction transaction, long gcBefore) {
        return new UnifiedCompactionTask(this.cfs, this, transaction, gcBefore, this.getShardManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeUpdateShardManager() {
        if (this.shardManager != null && !this.shardManager.isOutOfDate(StorageService.instance.getTokenMetadata().getRingVersion())) {
            return;
        }
        UnifiedCompactionStrategy unifiedCompactionStrategy = this;
        synchronized (unifiedCompactionStrategy) {
            while (this.shardManager == null || this.shardManager.isOutOfDate(StorageService.instance.getTokenMetadata().getRingVersion())) {
                this.shardManager = ShardManager.create(this.cfs);
            }
        }
    }

    @VisibleForTesting
    ShardManager getShardManager() {
        this.maybeUpdateShardManager();
        return this.shardManager;
    }

    @VisibleForTesting
    CompactionPick getNextCompactionPick(long gcBefore) {
        SelectionContext context = new SelectionContext(this.controller);
        List<SSTableReader> suitable = this.getCompactableSSTables(this.getSSTables(), UnifiedCompactionStrategy::isSuitableForCompaction);
        Set<SSTableReader> expired = this.maybeGetExpiredSSTables(gcBefore, suitable);
        suitable.removeAll(expired);
        CompactionPick selected = this.chooseCompactionPick(suitable, context);
        this.estimatedRemainingTasks = context.estimatedRemainingTasks;
        if (selected == null) {
            if (expired.isEmpty()) {
                return null;
            }
            return new CompactionPick(-1, -1, expired);
        }
        selected.addAll(expired);
        return selected;
    }

    private Set<SSTableReader> maybeGetExpiredSSTables(long gcBefore, List<SSTableReader> suitable) {
        Set<SSTableReader> expired;
        long ts = Clock.Global.currentTimeMillis();
        if (ts - this.lastExpiredCheck > this.controller.getExpiredSSTableCheckFrequency()) {
            this.lastExpiredCheck = ts;
            expired = CompactionController.getFullyExpiredSSTables(this.cfs, suitable, this.cfs.getOverlappingLiveSSTables(suitable), gcBefore, this.controller.getIgnoreOverlapsInExpirationCheck());
            if (logger.isTraceEnabled() && !expired.isEmpty()) {
                logger.trace("Expiration check for {}.{} found {} fully expired SSTables", new Object[]{this.cfs.getKeyspaceName(), this.cfs.getTableName(), expired.size()});
            }
        } else {
            expired = Collections.emptySet();
        }
        return expired;
    }

    private CompactionPick chooseCompactionPick(List<SSTableReader> suitable, SelectionContext context) {
        int maxOverlap = -1;
        CompactionPick selected = null;
        for (Level level : this.formLevels(suitable)) {
            CompactionPick pick = level.getCompactionPick(context);
            int levelOverlap = level.maxOverlap;
            if (levelOverlap <= maxOverlap) continue;
            maxOverlap = levelOverlap;
            selected = pick;
        }
        if (logger.isDebugEnabled() && selected != null) {
            logger.debug("Selected compaction on level {} overlap {} sstables {}", new Object[]{selected.level, selected.overlap, selected.size()});
        }
        return selected;
    }

    @Override
    public int getEstimatedRemainingTasks() {
        return this.estimatedRemainingTasks;
    }

    @Override
    public long getMaxSSTableBytes() {
        return Long.MAX_VALUE;
    }

    @VisibleForTesting
    public Controller getController() {
        return this.controller;
    }

    public static boolean isSuitableForCompaction(SSTableReader rdr) {
        return !rdr.isMarkedSuspect() && rdr.openReason != SSTableReader.OpenReason.EARLY;
    }

    @Override
    public synchronized void addSSTable(SSTableReader added) {
        this.sstables.add(added);
    }

    @Override
    public synchronized void removeSSTable(SSTableReader sstable) {
        this.sstables.remove(sstable);
    }

    @Override
    protected synchronized Set<SSTableReader> getSSTables() {
        return ImmutableSet.copyOf(Iterables.filter(this.cfs.getLiveSSTables(), this.sstables::contains));
    }

    @VisibleForTesting
    List<Level> getLevels() {
        return this.getLevels(this.getSSTables(), UnifiedCompactionStrategy::isSuitableForCompaction);
    }

    public List<Level> getLevels(Collection<SSTableReader> sstables, Predicate<SSTableReader> compactionFilter) {
        List<SSTableReader> suitable = this.getCompactableSSTables(sstables, compactionFilter);
        return this.formLevels(suitable);
    }

    private List<Level> formLevels(List<SSTableReader> suitable) {
        this.maybeUpdateShardManager();
        ArrayList<Level> levels = new ArrayList<Level>(32);
        suitable.sort(this.shardManager::compareByDensity);
        double maxDensity = this.controller.getMaxLevelDensity(0, this.controller.getBaseSstableSize(this.controller.getFanout(0)) / this.shardManager.localSpaceCoverage());
        int index = 0;
        Level level = new Level(this.controller, index, 0.0, maxDensity);
        block0: for (SSTableReader candidate : suitable) {
            double density = this.shardManager.density(candidate);
            if (density < level.max) {
                level.add(candidate);
                continue;
            }
            level.complete();
            levels.add(level);
            while (true) {
                double minDensity = maxDensity;
                maxDensity = this.controller.getMaxLevelDensity(++index, minDensity);
                level = new Level(this.controller, index, minDensity, maxDensity);
                if (density < level.max) {
                    level.add(candidate);
                    continue block0;
                }
                levels.add(level);
            }
        }
        if (!level.sstables.isEmpty()) {
            level.complete();
            levels.add(level);
        }
        return levels;
    }

    private List<SSTableReader> getCompactableSSTables(Collection<SSTableReader> sstables, Predicate<SSTableReader> compactionFilter) {
        Set<SSTableReader> compacting = this.cfs.getTracker().getCompacting();
        ArrayList<SSTableReader> suitable = new ArrayList<SSTableReader>(sstables.size());
        for (SSTableReader rdr : sstables) {
            if (!compactionFilter.test(rdr) || compacting.contains(rdr)) continue;
            suitable.add(rdr);
        }
        return suitable;
    }

    public TableMetadata getMetadata() {
        return this.cfs.metadata();
    }

    private static boolean startsAfter(SSTableReader a, SSTableReader b) {
        return a.getFirst().compareTo(b.getLast()) > 0;
    }

    public String toString() {
        return String.format("Unified strategy %s", this.getMetadata());
    }

    static class SelectionContext {
        final Controller controller;
        int estimatedRemainingTasks = 0;

        SelectionContext(Controller controller) {
            this.controller = controller;
        }
    }

    static class CompactionPick
    extends ArrayList<SSTableReader> {
        final int level;
        final int overlap;

        CompactionPick(int level, int overlap, Collection<SSTableReader> sstables) {
            super(sstables);
            this.level = level;
            this.overlap = overlap;
        }
    }

    public static class MultiSetBucket
    extends Bucket {
        final List<Set<SSTableReader>> overlapSets;

        public MultiSetBucket(Level level, List<Set<SSTableReader>> overlapSets) {
            super(level, overlapSets);
            this.overlapSets = overlapSets;
        }

        @Override
        Collection<SSTableReader> pullOldestSSTables(int overlapLimit) {
            return Overlaps.pullLastWithOverlapLimit(this.allSSTablesSorted, this.overlapSets, overlapLimit);
        }
    }

    public static class SimpleBucket
    extends Bucket {
        public SimpleBucket(Level level, Collection<SSTableReader> sstables) {
            super(level, sstables, sstables.size());
        }

        @Override
        Collection<SSTableReader> pullOldestSSTables(int overlapLimit) {
            if (this.allSSTablesSorted.size() <= overlapLimit) {
                return this.allSSTablesSorted;
            }
            return Overlaps.pullLast(this.allSSTablesSorted, overlapLimit);
        }
    }

    static abstract class Bucket {
        final Level level;
        final List<SSTableReader> allSSTablesSorted;
        final int maxOverlap;

        Bucket(Level level, Collection<SSTableReader> allSSTablesSorted, int maxOverlap) {
            this.level = level;
            this.allSSTablesSorted = new ArrayList<SSTableReader>(allSSTablesSorted);
            this.allSSTablesSorted.sort(SSTableReader.maxTimestampDescending);
            this.maxOverlap = maxOverlap;
        }

        Bucket(Level level, List<Set<SSTableReader>> overlapSections) {
            this.level = level;
            int maxOverlap = 0;
            HashSet<SSTableReader> all = new HashSet<SSTableReader>();
            for (Set<SSTableReader> section : overlapSections) {
                maxOverlap = Math.max(maxOverlap, section.size());
                all.addAll(section);
            }
            this.allSSTablesSorted = new ArrayList<SSTableReader>(all);
            this.allSSTablesSorted.sort(SSTableReader.maxTimestampDescending);
            this.maxOverlap = maxOverlap;
        }

        CompactionPick constructPick(Controller controller) {
            int count = this.maxOverlap;
            int threshold = this.level.threshold;
            int fanout = this.level.fanout;
            int index = this.level.index;
            int maxSSTablesToCompact = Math.max(fanout, controller.maxSSTablesToCompact());
            assert (count >= threshold);
            if (count <= fanout) {
                return new CompactionPick(index, count, this.allSSTablesSorted);
            }
            if (count <= fanout * controller.getFanout(index + 1) || maxSSTablesToCompact == fanout) {
                if (count <= maxSSTablesToCompact) {
                    return new CompactionPick(index, count, this.allSSTablesSorted);
                }
                return new CompactionPick(index, maxSSTablesToCompact, this.pullOldestSSTables(maxSSTablesToCompact));
            }
            int pickSize = this.selectPickSize(controller, maxSSTablesToCompact);
            return new CompactionPick(index, pickSize, this.pullOldestSSTables(pickSize));
        }

        private int selectPickSize(Controller controller, int maxSSTablesToCompact) {
            int pickSize;
            int fanout;
            int nextStep = fanout = this.level.fanout;
            int index = this.level.index;
            int limit = Math.min(maxSSTablesToCompact, this.maxOverlap);
            do {
                pickSize = nextStep;
            } while ((nextStep *= (fanout = controller.getFanout(++index))) <= limit);
            if (this.level.scalingParameter < 0) {
                pickSize *= limit / pickSize;
                assert (pickSize > 0);
            }
            return pickSize;
        }

        abstract Collection<SSTableReader> pullOldestSSTables(int var1);
    }

    public static class Level {
        final List<SSTableReader> sstables;
        final int index;
        final double survivalFactor;
        final int scalingParameter;
        final int fanout;
        final int threshold;
        final double min;
        final double max;
        int maxOverlap = -1;

        Level(Controller controller, int index, double minSize, double maxSize) {
            this.index = index;
            this.survivalFactor = controller.getSurvivalFactor(index);
            this.scalingParameter = controller.getScalingParameter(index);
            this.fanout = controller.getFanout(index);
            this.threshold = controller.getThreshold(index);
            this.sstables = new ArrayList<SSTableReader>(this.threshold);
            this.min = minSize;
            this.max = maxSize;
        }

        public Collection<SSTableReader> getSSTables() {
            return this.sstables;
        }

        public int getIndex() {
            return this.index;
        }

        void add(SSTableReader sstable) {
            this.sstables.add(sstable);
        }

        void complete() {
            if (logger.isTraceEnabled()) {
                logger.trace("Level: {}", (Object)this);
            }
        }

        CompactionPick getCompactionPick(SelectionContext context) {
            List<Bucket> buckets = this.getBuckets(context);
            if (buckets == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Level {} sstables {} max overlap {} buckets with compactions {} tasks {}", new Object[]{this.index, this.sstables.size(), this.maxOverlap, 0, 0});
                }
                return null;
            }
            int estimatedRemainingTasks = 0;
            int overlapMatchingCount = 0;
            Bucket selectedBucket = null;
            Controller controller = context.controller;
            for (Bucket bucket : buckets) {
                if (bucket.maxOverlap == this.maxOverlap && controller.random().nextInt(++overlapMatchingCount) == 0) {
                    selectedBucket = bucket;
                }
                estimatedRemainingTasks += bucket.maxOverlap / this.threshold;
            }
            context.estimatedRemainingTasks += estimatedRemainingTasks;
            assert (selectedBucket != null);
            if (logger.isDebugEnabled()) {
                logger.debug("Level {} sstables {} max overlap {} buckets with compactions {} tasks {}", new Object[]{this.index, this.sstables.size(), this.maxOverlap, buckets.size(), estimatedRemainingTasks});
            }
            CompactionPick selected = selectedBucket.constructPick(controller);
            if (logger.isTraceEnabled()) {
                logger.trace("Returning compaction pick with selected compaction {}", (Object)selected);
            }
            return selected;
        }

        @VisibleForTesting
        List<Bucket> getBuckets(SelectionContext context) {
            List<SSTableReader> liveSet = this.sstables;
            if (logger.isTraceEnabled()) {
                logger.trace("Creating compaction pick with live set {}", liveSet);
            }
            List overlaps = Overlaps.constructOverlapSets(liveSet, (x$0, x$1) -> UnifiedCompactionStrategy.startsAfter(x$0, x$1), SSTableReader.firstKeyComparator, SSTableReader.lastKeyComparator);
            for (Set<SSTableReader> set : overlaps) {
                this.maxOverlap = Math.max(this.maxOverlap, set.size());
            }
            if (this.maxOverlap < this.threshold) {
                return null;
            }
            List<Bucket> buckets = Overlaps.assignOverlapsIntoBuckets(this.threshold, context.controller.overlapInclusionMethod(), overlaps, this::makeBucket);
            return buckets;
        }

        private Bucket makeBucket(List<Set<SSTableReader>> overlaps, int startIndex, int endIndex) {
            return endIndex == startIndex + 1 ? new SimpleBucket(this, (Collection<SSTableReader>)overlaps.get(startIndex)) : new MultiSetBucket(this, overlaps.subList(startIndex, endIndex));
        }

        public String toString() {
            return String.format("W: %d, T: %d, F: %d, index: %d, min: %s, max %s, %d sstables, overlap %s", this.scalingParameter, this.threshold, this.fanout, this.index, this.densityAsString(this.min), this.densityAsString(this.max), this.sstables.size(), this.maxOverlap);
        }

        private String densityAsString(double density) {
            return FBUtilities.prettyPrintBinary(density, "B", " ");
        }
    }
}

