/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.CqlBuilder;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.cql3.functions.PartialScalarFunction;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;

final class PartiallyAppliedScalarFunction
extends NativeScalarFunction
implements PartialScalarFunction {
    private final ScalarFunction function;
    private final List<ByteBuffer> partialParameters;

    PartiallyAppliedScalarFunction(ScalarFunction function, List<ByteBuffer> partialParameters, int unresolvedCount) {
        super("__partial_application__", function.returnType(), PartiallyAppliedScalarFunction.computeArgTypes(function, partialParameters, unresolvedCount));
        this.function = function;
        this.partialParameters = partialParameters;
    }

    @Override
    public boolean isMonotonic() {
        return this.function.isNative() ? ((NativeScalarFunction)this.function).isPartialApplicationMonotonic(this.partialParameters) : this.function.isMonotonic();
    }

    @Override
    public boolean isPure() {
        return this.function.isPure();
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    @Override
    public Arguments newArguments(ProtocolVersion version) {
        return new PartialFunctionArguments(version, this.function, this.partialParameters, this.argTypes.size());
    }

    @Override
    public List<ByteBuffer> getPartialArguments() {
        return this.partialParameters;
    }

    private static AbstractType<?>[] computeArgTypes(ScalarFunction function, List<ByteBuffer> partialParameters, int unresolvedCount) {
        AbstractType[] argTypes = new AbstractType[unresolvedCount];
        int arg = 0;
        for (int i = 0; i < partialParameters.size(); ++i) {
            if (partialParameters.get(i) != UNRESOLVED) continue;
            argTypes[arg++] = function.argTypes().get(i);
        }
        return argTypes;
    }

    @Override
    public ByteBuffer execute(Arguments arguments) throws InvalidRequestException {
        return this.function.execute(arguments);
    }

    @Override
    public String toString() {
        CqlBuilder b = new CqlBuilder().append(this.function.name()).append(" : (");
        List<AbstractType<?>> types = this.function.argTypes();
        int m4 = types.size();
        for (int i = 0; i < m4; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.toCqlString(types.get(i)));
            if (this.partialParameters.get(i) == Function.UNRESOLVED) continue;
            b.append("(constant)");
        }
        b.append(") -> ").append(this.returnType);
        return b.toString();
    }

    private static final class PartialFunctionArguments
    implements Arguments {
        private final Arguments arguments;
        private final int[] mapping;

        public PartialFunctionArguments(ProtocolVersion version, ScalarFunction function, List<ByteBuffer> partialArguments, int unresolvedCount) {
            this.arguments = function.newArguments(version);
            this.mapping = new int[unresolvedCount];
            int mappingIndex = 0;
            int m4 = partialArguments.size();
            for (int i = 0; i < m4; ++i) {
                ByteBuffer argument = partialArguments.get(i);
                if (argument != Function.UNRESOLVED) {
                    this.arguments.set(i, argument);
                    continue;
                }
                this.mapping[mappingIndex++] = i;
            }
        }

        @Override
        public ProtocolVersion getProtocolVersion() {
            return this.arguments.getProtocolVersion();
        }

        @Override
        public void set(int i, ByteBuffer buffer) {
            this.arguments.set(this.mapping[i], buffer);
        }

        @Override
        public boolean containsNulls() {
            return this.arguments.containsNulls();
        }

        @Override
        public <T> T get(int i) {
            return this.arguments.get(i);
        }

        @Override
        public int size() {
            return this.arguments.size();
        }
    }
}

