/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.auth.AuthCache;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Role;
import org.apache.cassandra.auth.RoleOptions;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.Roles;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;

public interface IRoleManager
extends AuthCache.BulkLoader<RoleResource, Set<Role>> {
    public Set<Option> supportedOptions();

    public Set<Option> alterableOptions();

    public void createRole(AuthenticatedUser var1, RoleResource var2, RoleOptions var3) throws RequestValidationException, RequestExecutionException;

    public void dropRole(AuthenticatedUser var1, RoleResource var2) throws RequestValidationException, RequestExecutionException;

    public void alterRole(AuthenticatedUser var1, RoleResource var2, RoleOptions var3) throws RequestValidationException, RequestExecutionException;

    public void grantRole(AuthenticatedUser var1, RoleResource var2, RoleResource var3) throws RequestValidationException, RequestExecutionException;

    public void revokeRole(AuthenticatedUser var1, RoleResource var2, RoleResource var3) throws RequestValidationException, RequestExecutionException;

    public Set<RoleResource> getRoles(RoleResource var1, boolean var2) throws RequestValidationException, RequestExecutionException;

    default public Set<Role> getRoleDetails(RoleResource grantee) {
        return this.getRoles(grantee, true).stream().map(roleResource -> Roles.fromRoleResource(roleResource, this)).collect(Collectors.toSet());
    }

    public Set<RoleResource> getAllRoles() throws RequestValidationException, RequestExecutionException;

    public boolean isSuper(RoleResource var1);

    public boolean canLogin(RoleResource var1);

    public Map<String, String> getCustomOptions(RoleResource var1);

    public boolean isExistingRole(RoleResource var1);

    public Set<? extends IResource> protectedResources();

    public void validateConfiguration() throws ConfigurationException;

    public void setup();

    default public String roleForIdentity(String identity) {
        return null;
    }

    default public Map<String, String> authorizedIdentities() {
        return Collections.emptyMap();
    }

    default public void addIdentity(String identity, String role) {
    }

    default public boolean isExistingIdentity(String identity) {
        return false;
    }

    default public void dropIdentity(String identity) {
    }

    public static enum Option {
        SUPERUSER,
        PASSWORD,
        LOGIN,
        OPTIONS,
        HASHED_PASSWORD;

    }
}

