/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.reader;

import net.openhft.chronicle.queue.reader.MessageConsumer;

public final class MessageCountingMessageConsumer
implements MessageConsumer {
    private final long matchLimit;
    private final MessageConsumer wrappedConsumer;
    private long matches = 0L;

    public MessageCountingMessageConsumer(long matchLimit, MessageConsumer wrappedConsumer) {
        this.matchLimit = matchLimit;
        this.wrappedConsumer = wrappedConsumer;
    }

    @Override
    public boolean consume(long index, String message) {
        boolean consume = this.wrappedConsumer.consume(index, message);
        if (consume) {
            ++this.matches;
        }
        return consume;
    }

    public boolean matchLimitReached() {
        return this.matchLimit > 0L && this.matches >= this.matchLimit;
    }
}

