/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.partitioner;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.spark.data.SSTablesSupplier;
import org.apache.cassandra.spark.data.partitioner.MultiDCReplicas;
import org.apache.cassandra.spark.reader.SparkSSTableReader;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class MultiDCReplicasTest {
    @Mock
    private SSTablesSupplier dc1Supplier;
    @Mock
    private SSTablesSupplier dc2Supplier;
    @Mock
    private SSTablesSupplier.ReaderOpener<TestSparkSSTableReader> readerOpener;
    private MultiDCReplicas multiDCReplicas;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks((Object)this);
    }

    @Test
    void testConstructorWithValidMap() {
        HashMap<String, SSTablesSupplier> replicasMap = new HashMap<String, SSTablesSupplier>();
        replicasMap.put("dc1", this.dc1Supplier);
        replicasMap.put("dc2", this.dc2Supplier);
        this.multiDCReplicas = new MultiDCReplicas(replicasMap);
        Assertions.assertThat((Object)this.multiDCReplicas).isNotNull();
    }

    @Test
    void testConstructorWithNullMap() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new MultiDCReplicas(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("replicasPerDC cannot be null or empty");
    }

    @Test
    void testConstructorWithEmptyMap() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new MultiDCReplicas(Map.of())).isInstanceOf(IllegalArgumentException.class)).hasMessage("replicasPerDC cannot be null or empty");
    }

    @Test
    void testOpenAllWithMultipleDCs() {
        Map<String, SSTablesSupplier> replicasMap = Map.of("dc1", this.dc1Supplier, "dc2", this.dc2Supplier);
        TestSparkSSTableReader reader1 = new TestSparkSSTableReader(BigInteger.ONE, BigInteger.TEN);
        TestSparkSSTableReader reader2 = new TestSparkSSTableReader(BigInteger.valueOf(11L), BigInteger.valueOf(20L));
        TestSparkSSTableReader reader3 = new TestSparkSSTableReader(BigInteger.valueOf(21L), BigInteger.valueOf(30L));
        Set<TestSparkSSTableReader> dc1Readers = Set.of(reader1, reader2);
        Set<TestSparkSSTableReader> dc2Readers = Set.of(reader3);
        Mockito.when((Object)this.dc1Supplier.openAll(this.readerOpener)).thenReturn(dc1Readers);
        Mockito.when((Object)this.dc2Supplier.openAll(this.readerOpener)).thenReturn(dc2Readers);
        this.multiDCReplicas = new MultiDCReplicas(replicasMap);
        Set result = this.multiDCReplicas.openAll(this.readerOpener);
        Assertions.assertThat((Collection)result).hasSize(3);
        Assertions.assertThat((Collection)result).containsExactlyInAnyOrder((Object[])new TestSparkSSTableReader[]{reader1, reader2, reader3});
    }

    @Test
    void testOpenAllWithSingleDC() {
        HashMap<String, SSTablesSupplier> replicasMap = new HashMap<String, SSTablesSupplier>();
        replicasMap.put("dc1", this.dc1Supplier);
        TestSparkSSTableReader reader1 = new TestSparkSSTableReader(BigInteger.ONE, BigInteger.TEN);
        TestSparkSSTableReader reader2 = new TestSparkSSTableReader(BigInteger.valueOf(11L), BigInteger.valueOf(20L));
        Set<TestSparkSSTableReader> dc1Readers = Set.of(reader1, reader2);
        Mockito.when((Object)this.dc1Supplier.openAll(this.readerOpener)).thenReturn(dc1Readers);
        this.multiDCReplicas = new MultiDCReplicas(replicasMap);
        Set result = this.multiDCReplicas.openAll(this.readerOpener);
        Assertions.assertThat((Collection)result).hasSize(2);
        Assertions.assertThat((Collection)result).containsExactlyInAnyOrder((Object[])new TestSparkSSTableReader[]{reader1, reader2});
    }

    @Test
    void testOpenAllWithEmptySupplierResults() {
        HashMap<String, SSTablesSupplier> replicasMap = new HashMap<String, SSTablesSupplier>();
        replicasMap.put("dc1", this.dc1Supplier);
        replicasMap.put("dc2", this.dc2Supplier);
        Mockito.when((Object)this.dc1Supplier.openAll(this.readerOpener)).thenReturn(new HashSet());
        Mockito.when((Object)this.dc2Supplier.openAll(this.readerOpener)).thenReturn(new HashSet());
        this.multiDCReplicas = new MultiDCReplicas(replicasMap);
        Set result = this.multiDCReplicas.openAll(this.readerOpener);
        Assertions.assertThat((Collection)result).isNotNull();
        Assertions.assertThat((Collection)result).isEmpty();
    }

    @Test
    void testOpenAllWithDuplicateReaders() {
        HashMap<String, SSTablesSupplier> replicasMap = new HashMap<String, SSTablesSupplier>();
        replicasMap.put("dc1", this.dc1Supplier);
        replicasMap.put("dc2", this.dc2Supplier);
        TestSparkSSTableReader reader1 = new TestSparkSSTableReader(BigInteger.ONE, BigInteger.TEN);
        TestSparkSSTableReader reader2 = new TestSparkSSTableReader(BigInteger.valueOf(11L), BigInteger.valueOf(20L));
        Set<TestSparkSSTableReader> dc1Readers = Set.of(reader1, reader2);
        Set<TestSparkSSTableReader> dc2Readers = Set.of(reader1, reader2);
        Mockito.when((Object)this.dc1Supplier.openAll(this.readerOpener)).thenReturn(dc1Readers);
        Mockito.when((Object)this.dc2Supplier.openAll(this.readerOpener)).thenReturn(dc2Readers);
        this.multiDCReplicas = new MultiDCReplicas(replicasMap);
        Set result = this.multiDCReplicas.openAll(this.readerOpener);
        Assertions.assertThat((Collection)result).hasSize(2);
        Assertions.assertThat((Collection)result).containsExactlyInAnyOrder((Object[])new TestSparkSSTableReader[]{reader1, reader2});
    }

    private static class TestSparkSSTableReader
    implements SparkSSTableReader {
        private final BigInteger firstToken;
        private final BigInteger lastToken;

        TestSparkSSTableReader(BigInteger firstToken, BigInteger lastToken) {
            this.firstToken = firstToken;
            this.lastToken = lastToken;
        }

        public BigInteger firstToken() {
            return this.firstToken;
        }

        public BigInteger lastToken() {
            return this.lastToken;
        }

        public boolean ignore() {
            return false;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TestSparkSSTableReader)) {
                return false;
            }
            TestSparkSSTableReader that = (TestSparkSSTableReader)obj;
            return this.firstToken.equals(that.firstToken) && this.lastToken.equals(that.lastToken);
        }

        public int hashCode() {
            return this.firstToken.hashCode() + this.lastToken.hashCode();
        }
    }
}

