/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.client.SidecarInstanceImpl;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.DataTransport;
import org.apache.cassandra.spark.bulkwriter.DigestAlgorithms;
import org.apache.cassandra.spark.bulkwriter.WriterOptions;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedWriteConf;
import org.apache.cassandra.spark.bulkwriter.util.SbwKryoRegistrator;
import org.apache.cassandra.spark.utils.BuildInfo;
import org.apache.spark.SparkConf;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class BulkSparkConfTest {
    private SparkConf sparkConf;
    private BulkSparkConf bulkSparkConf;
    private Map<String, String> defaultOptions;

    BulkSparkConfTest() {
    }

    @BeforeEach
    void before() {
        this.sparkConf = new SparkConf();
        this.defaultOptions = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        this.defaultOptions.put(WriterOptions.SIDECAR_INSTANCES.name(), "127.0.0.1");
        this.defaultOptions.put(WriterOptions.KEYSPACE.name(), "ks");
        this.defaultOptions.put(WriterOptions.TABLE.name(), "table");
        this.defaultOptions.put(WriterOptions.KEYSTORE_PASSWORD.name(), "dummy_password");
        this.defaultOptions.put(WriterOptions.KEYSTORE_PATH.name(), "dummy_path");
        this.bulkSparkConf = new BulkSparkConf(this.sparkConf, this.defaultOptions);
    }

    @Test
    void testGetBoolean() {
        this.sparkConf.set("spark.cassandra_analytics.job.skip_clean", "true");
        Assertions.assertThat((boolean)this.bulkSparkConf.getSkipClean()).isTrue();
    }

    @Test
    void testGetLong() {
        this.sparkConf.set("spark.cassandra_analytics.sidecar.request.retries.delay.milliseconds", "2222");
        Assertions.assertThat((long)this.bulkSparkConf.getSidecarRequestRetryDelayMillis()).isEqualTo(2222L);
    }

    @Test
    void testGetInt() {
        this.sparkConf.set("spark.cassandra_analytics.request.max_connections", "1234");
        Assertions.assertThat((int)this.bulkSparkConf.getMaxHttpConnections()).isEqualTo(1234);
    }

    @Test
    void deprecatedSettingsAreHonored() {
        this.sparkConf.set("qwerty.request.max_connections", "1234");
        this.sparkConf.set("asdfgh.request.max_connections", "000000");
        this.sparkConf.set("zxcvbn.request.response_timeout", "5678");
        BulkSparkConf bulkSparkConf = new BulkSparkConf(this.sparkConf, this.defaultOptions){

            @NotNull
            protected List<String> getDeprecatedSettingPrefixes() {
                return ImmutableList.of((Object)"qwerty.", (Object)"asdfgh.", (Object)"zxcvbn.");
            }
        };
        Assertions.assertThat((int)bulkSparkConf.getMaxHttpConnections()).isEqualTo(1234);
        Assertions.assertThat((int)bulkSparkConf.getHttpResponseTimeoutMs()).isEqualTo(5678);
    }

    @Test
    void calculatesCoresCorrectlyForStaticAllocation() {
        this.sparkConf.set("spark.executor.cores", "5");
        this.sparkConf.set("spark.executor.instances", "5");
        Assertions.assertThat((Integer)this.bulkSparkConf.getCores()).isEqualTo(25);
    }

    @Test
    void calculatesCoresCorrectlyForDynamicAllocation() {
        this.sparkConf.set("spark.executor.cores", "6");
        this.sparkConf.set("spark.dynamicAllocation.maxExecutors", "7");
        Assertions.assertThat((Integer)this.bulkSparkConf.getCores()).isEqualTo(42);
    }

    @Test
    void ensureSetupSparkConfAddsPerformsNecessaryTasks() {
        Assertions.assertThat((String)this.sparkConf.get("spark.kryo.registrator", "")).isEmpty();
        Assertions.assertThat((String)this.sparkConf.get("spark.executor.extraJavaOptions", "")).isEmpty();
        BulkSparkConf.setupSparkConf((SparkConf)this.sparkConf, (boolean)true);
        Assertions.assertThat((String)this.sparkConf.get("spark.kryo.registrator", "")).isEqualTo("," + SbwKryoRegistrator.class.getName());
        if (BuildInfo.isAtLeastJava11((String)BuildInfo.javaSpecificationVersion())) {
            Assertions.assertThat((String)this.sparkConf.get("spark.executor.extraJavaOptions", "")).isEqualTo(" -Djdk.attach.allowAttachSelf=true --add-exports java.base/jdk.internal.misc=ALL-UNNAMED --add-exports java.base/jdk.internal.ref=ALL-UNNAMED --add-exports java.base/sun.nio.ch=ALL-UNNAMED --add-exports java.management.rmi/com.sun.jmx.remote.internal.rmi=ALL-UNNAMED --add-exports java.rmi/sun.rmi.registry=ALL-UNNAMED --add-exports java.rmi/sun.rmi.server=ALL-UNNAMED --add-exports java.sql/java.sql=ALL-UNNAMED --add-opens java.base/java.lang.module=ALL-UNNAMED --add-opens java.base/jdk.internal.loader=ALL-UNNAMED --add-opens java.base/jdk.internal.ref=ALL-UNNAMED --add-opens java.base/jdk.internal.reflect=ALL-UNNAMED --add-opens java.base/jdk.internal.math=ALL-UNNAMED --add-opens java.base/jdk.internal.module=ALL-UNNAMED --add-opens java.base/jdk.internal.util.jar=ALL-UNNAMED --add-opens jdk.management/com.sun.management.internal=ALL-UNNAMED");
        }
    }

    @Test
    void withProperMtlsSettingsWillCreateSuccessfully() {
        Map<String, String> options = this.copyDefaultOptions();
        SparkConf sparkConf = new SparkConf();
        Assertions.assertThatNoException().isThrownBy(() -> new BulkSparkConf(sparkConf, options, null));
    }

    @Test
    void keystorePathRequiredIfBase64EncodedKeystoreNotSet() {
        Map<String, String> options = this.copyDefaultOptions();
        options.remove(WriterOptions.KEYSTORE_PATH.name());
        SparkConf sparkConf = new SparkConf();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BulkSparkConf(sparkConf, options)).isExactlyInstanceOf(NullPointerException.class)).hasMessage("Keystore password was set. But both keystore path and base64 encoded string are not set. Please either set option " + String.valueOf(WriterOptions.KEYSTORE_PATH) + " or option " + String.valueOf(WriterOptions.KEYSTORE_BASE64_ENCODED));
    }

    @Test
    void testSkipClean() {
        Assertions.assertThat((boolean)this.bulkSparkConf.getSkipClean()).isFalse();
        this.sparkConf.set("spark.cassandra_analytics.job.skip_clean", "true");
        Assertions.assertThat((boolean)this.bulkSparkConf.getSkipClean()).isTrue();
    }

    @Test
    void testDefaultSidecarPort() {
        this.bulkSparkConf = new BulkSparkConf(new SparkConf(), this.defaultOptions);
        Assertions.assertThat((int)this.bulkSparkConf.getUserProvidedSidecarPort()).isEqualTo(-1);
        Assertions.assertThat((int)this.bulkSparkConf.getEffectiveSidecarPort()).isEqualTo(9043);
    }

    @Test
    void testSidecarPortSetByOptions() {
        Map<String, String> options = this.copyDefaultOptions();
        options.put(WriterOptions.SIDECAR_PORT.name(), "9999");
        this.bulkSparkConf = new BulkSparkConf(new SparkConf(), options);
        Assertions.assertThat((int)this.bulkSparkConf.getUserProvidedSidecarPort()).isEqualTo(9999);
        Assertions.assertThat((int)this.bulkSparkConf.getEffectiveSidecarPort()).isEqualTo(9999);
    }

    @Test
    void testSidecarPortSetByProperty() {
        SparkConf conf = new SparkConf().set("spark.cassandra_analytics.ports.sidecar", "9876");
        this.bulkSparkConf = new BulkSparkConf(conf, this.defaultOptions);
        Assertions.assertThat((int)this.bulkSparkConf.getUserProvidedSidecarPort()).isEqualTo(9876);
        Assertions.assertThat((int)this.bulkSparkConf.getEffectiveSidecarPort()).isEqualTo(9876);
    }

    @Test
    void testKeystoreBase64EncodedStringSet() {
        Map<String, String> options = this.copyDefaultOptions();
        options.remove(WriterOptions.KEYSTORE_PATH.name());
        options.put(WriterOptions.KEYSTORE_BASE64_ENCODED.name(), "dummy_base64_encoded_keystore");
        Assertions.assertThatNoException().isThrownBy(() -> new BulkSparkConf(this.sparkConf, this.defaultOptions));
    }

    @Test
    void testTrustStorePasswordSetPathNotSet() {
        Map<String, String> options = this.copyDefaultOptions();
        options.put(WriterOptions.TRUSTSTORE_PATH.name(), "dummy");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BulkSparkConf(this.sparkConf, options)).isExactlyInstanceOf(NullPointerException.class)).hasMessage("Trust Store Path was provided, but password is missing. Please provide option " + String.valueOf(WriterOptions.TRUSTSTORE_PASSWORD));
    }

    @Test
    void testQuoteIdentifiers() {
        Assertions.assertThat((boolean)this.bulkSparkConf.quoteIdentifiers).isFalse();
        Map<String, String> options = this.copyDefaultOptions();
        options.put(WriterOptions.QUOTE_IDENTIFIERS.name(), "true");
        BulkSparkConf bulkSparkConf = new BulkSparkConf(this.sparkConf, options);
        Assertions.assertThat((Object)bulkSparkConf).isNotNull();
        Assertions.assertThat((boolean)bulkSparkConf.quoteIdentifiers).isTrue();
    }

    @Test
    void testInvalidJobKeepAliveMinutes() {
        Map<String, String> options = this.copyDefaultOptions();
        options.put(WriterOptions.JOB_KEEP_ALIVE_MINUTES.name(), "-100");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BulkSparkConf(this.sparkConf, options)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid value for the 'JOB_KEEP_ALIVE_MINUTES' Bulk Writer option (-100). It cannot be less than the minimum 10");
    }

    @Test
    void testDefaultJobKeepAliveMinutes() {
        Map<String, String> options = this.copyDefaultOptions();
        BulkSparkConf conf = new BulkSparkConf(this.sparkConf, options);
        Assertions.assertThat((int)conf.getJobKeepAliveMinutes()).isEqualTo(10);
    }

    @Test
    void testJobKeepAliveMinutes() {
        Map<String, String> options = this.copyDefaultOptions();
        options.put(WriterOptions.JOB_KEEP_ALIVE_MINUTES.name(), "30");
        BulkSparkConf conf = new BulkSparkConf(this.sparkConf, options);
        Assertions.assertThat((int)conf.getJobKeepAliveMinutes()).isEqualTo(30);
    }

    @Test
    void testSidecarContactPoints() {
        Map<String, String> options = this.copyDefaultOptions();
        Assertions.assertThat((String)BulkSparkConf.resolveSidecarContactPoints(options)).isEqualTo("127.0.0.1");
        String sidecarInstances = "127.0.0.1,128.0.0.2";
        options.put(WriterOptions.SIDECAR_INSTANCES.name(), sidecarInstances);
        Assertions.assertThat((String)BulkSparkConf.resolveSidecarContactPoints(options)).isEqualTo(sidecarInstances);
        String contactPoints = "localhost1,localhost2";
        options.put(WriterOptions.SIDECAR_CONTACT_POINTS.name(), contactPoints);
        Assertions.assertThat((String)BulkSparkConf.resolveSidecarContactPoints(options)).isEqualTo(contactPoints);
        String contactPointsWithPort = "localhost1:9999,localhost2:9999";
        options.put(WriterOptions.SIDECAR_CONTACT_POINTS.name(), contactPointsWithPort);
        Assertions.assertThat((String)BulkSparkConf.resolveSidecarContactPoints(options)).isEqualTo(contactPointsWithPort);
        options.remove(WriterOptions.SIDECAR_INSTANCES.name());
        options.remove(WriterOptions.SIDECAR_CONTACT_POINTS.name());
        ((AbstractStringAssert)Assertions.assertThat((String)BulkSparkConf.resolveSidecarContactPoints(options)).describedAs("When none of the sidecar options are define. It resolves to the default value null", new Object[0])).isNull();
    }

    @Test
    void testReadCoordinatedWriteConfFails() {
        Map<String, String> options = this.copyDefaultOptions();
        String coordinatedWriteConfJsonNoLocalDc = "{\"cluster1\":{\"sidecarContactPoints\":[\"instance-1:9999\",\"instance-2:9999\",\"instance-3:9999\"]}}";
        options.put(WriterOptions.COORDINATED_WRITE_CONFIG.name(), coordinatedWriteConfJsonNoLocalDc);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BulkSparkConf(this.sparkConf, options)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Coordinated write only supports S3_COMPAT");
        options.put(WriterOptions.DATA_TRANSPORT.name(), DataTransport.S3_COMPAT.name());
        options.put(WriterOptions.BULK_WRITER_CL.name(), "LOCAL_QUORUM");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BulkSparkConf(this.sparkConf, options)).isExactlyInstanceOf(IllegalStateException.class)).hasMessage("localDc is not configured for cluster: cluster1 for consistency level: LOCAL_QUORUM");
        options.put(WriterOptions.COORDINATED_WRITE_CONFIG.name(), "invalid json");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BulkSparkConf(this.sparkConf, options)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Unable to parse json string into CoordinatedWriteConf of SimpleClusterConf due to Unrecognized token 'invalid'");
    }

    @Test
    void testCoordinatedWriteConf() {
        Map<String, String> options = this.copyDefaultOptions();
        options.remove(WriterOptions.COORDINATED_WRITE_CONFIG.name());
        BulkSparkConf conf = new BulkSparkConf(this.sparkConf, options);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)conf.isCoordinatedWriteConfigured()).describedAs("When COORDINATED_WRITE_CONF is absent, isCoordinatedWriteConfigured should return false", new Object[0])).isFalse();
        String coordinatedWriteConfJson = "{\"cluster1\":{\"sidecarContactPoints\":[\"instance-1:9999\",\"instance-2:9999\",\"instance-3:9999\"],\"localDc\":\"dc1\"},\"cluster2\":{\"sidecarContactPoints\":[\"instance-4:8888\",\"instance-5:8888\",\"instance-6:8888\"],\"localDc\":\"dc1\"}}";
        options.put(WriterOptions.DATA_TRANSPORT.name(), DataTransport.S3_COMPAT.name());
        options.put(WriterOptions.BULK_WRITER_CL.name(), "LOCAL_QUORUM");
        options.put(WriterOptions.COORDINATED_WRITE_CONFIG.name(), coordinatedWriteConfJson);
        conf = new BulkSparkConf(this.sparkConf, options);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)conf.isCoordinatedWriteConfigured()).describedAs("When COORDINATED_WRITE_CONF is present, it should return true", new Object[0])).isTrue();
        Assertions.assertThat((Map)conf.coordinatedWriteConf().clusters()).containsOnlyKeys((Object[])new String[]{"cluster1", "cluster2"});
        CoordinatedWriteConf.ClusterConf cluster1 = conf.coordinatedWriteConf().cluster("cluster1");
        Assertions.assertThat((Object)cluster1).isNotNull();
        Assertions.assertThat((Collection)cluster1.sidecarContactPoints()).containsExactlyInAnyOrder((Object[])new SidecarInstance[]{new SidecarInstanceImpl("instance-1", 9999), new SidecarInstanceImpl("instance-2", 9999), new SidecarInstanceImpl("instance-3", 9999)});
        Assertions.assertThat((String)cluster1.localDc()).isEqualTo("dc1");
        CoordinatedWriteConf.ClusterConf cluster2 = conf.coordinatedWriteConf().cluster("cluster2");
        Assertions.assertThat((Object)cluster2).isNotNull();
        Assertions.assertThat((Collection)cluster2.sidecarContactPoints()).containsExactlyInAnyOrder((Object[])new SidecarInstance[]{new SidecarInstanceImpl("instance-4", 8888), new SidecarInstanceImpl("instance-5", 8888), new SidecarInstanceImpl("instance-6", 8888)});
        Assertions.assertThat((String)cluster2.localDc()).isEqualTo("dc1");
    }

    @Test
    void testDigestAlgorithmSupplierIsXXHashForS3CompactMode() {
        Map<String, String> options = this.copyDefaultOptions();
        options.put(WriterOptions.DATA_TRANSPORT.name(), DataTransport.S3_COMPAT.name());
        BulkSparkConf conf = new BulkSparkConf(this.sparkConf, options);
        Assertions.assertThat((Object)conf.digestAlgorithmSupplier).isSameAs((Object)DigestAlgorithms.XXHASH32);
        options.put(WriterOptions.DIGEST.name(), DigestAlgorithms.MD5.name());
        conf = new BulkSparkConf(this.sparkConf, options);
        ((ObjectAssert)Assertions.assertThat((Object)conf.digestAlgorithmSupplier).describedAs("Even if DIGEST option is set, the digest algorithm is XXHash32 for S3_COMPAT mode", new Object[0])).isSameAs((Object)DigestAlgorithms.XXHASH32);
    }

    @Test
    void testCassandraRoleRead() {
        Map<String, String> options = this.copyDefaultOptions();
        BulkSparkConf conf = new BulkSparkConf(this.sparkConf, options);
        Assertions.assertThat((String)conf.cassandraRole).isNull();
        options.put(WriterOptions.CASSANDRA_ROLE.name(), "custom_role");
        conf = new BulkSparkConf(this.sparkConf, options);
        Assertions.assertThat((String)conf.cassandraRole).isEqualTo("custom_role");
    }

    private Map<String, String> copyDefaultOptions() {
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        map.putAll(this.defaultOptions);
        return map;
    }
}

