/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.dapr.DaprComponent;

/**
 * Dapr component which interfaces with Dapr Building Blocks.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface DaprComponentBuilderFactory {

    /**
     * Dapr (camel-dapr)
     * Dapr component which interfaces with Dapr Building Blocks.
     * 
     * Category: cloud,saas
     * Since: 4.12
     * Maven coordinates: org.apache.camel:camel-dapr
     * 
     * @return the dsl builder
     */
    static DaprComponentBuilder dapr() {
        return new DaprComponentBuilderImpl();
    }

    /**
     * Builder for the Dapr component.
     */
    interface DaprComponentBuilder extends ComponentBuilder<DaprComponent> {
    
        /**
         * The Dapr Client.
         * 
         * The option is a: &lt;code&gt;io.dapr.client.DaprClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder client(io.dapr.client.DaprClient client) {
            doSetProperty("client", client);
            return this;
        }
    
        /**
         * List of keys for configuration operation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configKeys the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder configKeys(java.lang.String configKeys) {
            doSetProperty("configKeys", configKeys);
            return this;
        }
    
        /**
         * The name of the Dapr configuration store to interact with, defined in
         * statestore.yaml config.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configStore the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder configStore(java.lang.String configStore) {
            doSetProperty("configStore", configStore);
            return this;
        }
    
        /**
         * The component configurations.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.dapr.DaprConfiguration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder configuration(org.apache.camel.component.dapr.DaprConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        /**
         * The contentType for the Pub/Sub component to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder contentType(java.lang.String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
    
        /**
         * The Dapr Preview Client.
         * 
         * The option is a:
         * &lt;code&gt;io.dapr.client.DaprPreviewClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param previewClient the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder previewClient(io.dapr.client.DaprPreviewClient previewClient) {
            doSetProperty("previewClient", previewClient);
            return this;
        }
    
        /**
         * The name of the Dapr Pub/Sub component to use. This identifies which
         * underlying messaging system Dapr will interact with for publishing or
         * subscribing to events.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pubSubName the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder pubSubName(java.lang.String pubSubName) {
            doSetProperty("pubSubName", pubSubName);
            return this;
        }
    
        /**
         * The name of the topic to subscribe to. The topic must exist in the
         * Pub/Sub component configured under the given pubsubName.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param topic the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder topic(java.lang.String topic) {
            doSetProperty("topic", topic);
            return this;
        }
    
        
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    
        /**
         * The name of the Dapr binding to invoke.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param bindingName the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder bindingName(java.lang.String bindingName) {
            doSetProperty("bindingName", bindingName);
            return this;
        }
    
        /**
         * The operation to perform on the binding.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param bindingOperation the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder bindingOperation(java.lang.String bindingOperation) {
            doSetProperty("bindingOperation", bindingOperation);
            return this;
        }
    
        /**
         * Concurrency mode to use with state operations.
         * 
         * The option is a:
         * &lt;code&gt;io.dapr.client.domain.StateOptions.Concurrency&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param concurrency the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder concurrency(io.dapr.client.domain.StateOptions.Concurrency concurrency) {
            doSetProperty("concurrency", concurrency);
            return this;
        }
    
        /**
         * Consistency level to use with state operations.
         * 
         * The option is a:
         * &lt;code&gt;io.dapr.client.domain.StateOptions.Consistency&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param consistency the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder consistency(io.dapr.client.domain.StateOptions.Consistency consistency) {
            doSetProperty("consistency", consistency);
            return this;
        }
    
        /**
         * The eTag for optimistic concurrency during state save or delete
         * operations.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param eTag the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder eTag(java.lang.String eTag) {
            doSetProperty("eTag", eTag);
            return this;
        }
    
        /**
         * The name of the event. Event names are case-insensitive.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param eventName the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder eventName(java.lang.String eventName) {
            doSetProperty("eventName", eventName);
            return this;
        }
    
        /**
         * The expiry time in seconds for the lock.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param expiryInSeconds the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder expiryInSeconds(java.lang.Integer expiryInSeconds) {
            doSetProperty("expiryInSeconds", expiryInSeconds);
            return this;
        }
    
        
        /**
         * Set true to fetch the workflow instance's inputs, outputs, and custom
         * status, or false to omit.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param getWorkflowIO the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder getWorkflowIO(boolean getWorkflowIO) {
            doSetProperty("getWorkflowIO", getWorkflowIO);
            return this;
        }
    
        /**
         * HTTP method to use when invoking the service. Accepts verbs like GET,
         * POST, PUT, DELETE, etc. Creates a minimal HttpExtension with no
         * headers or query params. Takes precedence over verb.
         * 
         * The option is a:
         * &lt;code&gt;io.dapr.client.domain.HttpExtension&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param httpExtension the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder httpExtension(io.dapr.client.domain.HttpExtension httpExtension) {
            doSetProperty("httpExtension", httpExtension);
            return this;
        }
    
        /**
         * The key used to identify the state/secret object within the specified
         * state/secret store.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder key(java.lang.String key) {
            doSetProperty("key", key);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        
        /**
         * The lock operation to perform on the store. Required for
         * DaprOperation.lock operation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.dapr.LockOperation&lt;/code&gt; type.
         * 
         * Default: tryLock
         * Group: producer
         * 
         * @param lockOperation the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder lockOperation(org.apache.camel.component.dapr.LockOperation lockOperation) {
            doSetProperty("lockOperation", lockOperation);
            return this;
        }
    
        /**
         * The lock owner identifier for the lock.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param lockOwner the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder lockOwner(java.lang.String lockOwner) {
            doSetProperty("lockOwner", lockOwner);
            return this;
        }
    
        /**
         * The name of the method or route to invoke on the target service.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param methodToInvoke the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder methodToInvoke(java.lang.String methodToInvoke) {
            doSetProperty("methodToInvoke", methodToInvoke);
            return this;
        }
    
        /**
         * Reason for suspending/resuming the workflow instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param reason the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder reason(java.lang.String reason) {
            doSetProperty("reason", reason);
            return this;
        }
    
        /**
         * The resource Id for the lock.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param resourceId the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder resourceId(java.lang.String resourceId) {
            doSetProperty("resourceId", resourceId);
            return this;
        }
    
        /**
         * The name of the Dapr secret store to interact with, defined in
         * local-secret-store.yaml config.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param secretStore the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder secretStore(java.lang.String secretStore) {
            doSetProperty("secretStore", secretStore);
            return this;
        }
    
        /**
         * Target service to invoke. Can be a Dapr App ID, a named HTTPEndpoint,
         * or a FQDN/public URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param serviceToInvoke the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder serviceToInvoke(java.lang.String serviceToInvoke) {
            doSetProperty("serviceToInvoke", serviceToInvoke);
            return this;
        }
    
        
        /**
         * The state operation to perform on the state store. Required for
         * DaprOperation.state operation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.dapr.StateOperation&lt;/code&gt; type.
         * 
         * Default: get
         * Group: producer
         * 
         * @param stateOperation the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder stateOperation(org.apache.camel.component.dapr.StateOperation stateOperation) {
            doSetProperty("stateOperation", stateOperation);
            return this;
        }
    
        /**
         * The name of the Dapr state store to interact with, defined in
         * statestore.yaml config.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param stateStore the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder stateStore(java.lang.String stateStore) {
            doSetProperty("stateStore", stateStore);
            return this;
        }
    
        /**
         * The lock store name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param storeName the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder storeName(java.lang.String storeName) {
            doSetProperty("storeName", storeName);
            return this;
        }
    
        /**
         * The amount of time to wait for the workflow instance to
         * start/complete.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder timeout(java.time.Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
    
        
        /**
         * The HTTP verb to use for invoking the method.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: POST
         * Group: producer
         * 
         * @param verb the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder verb(java.lang.String verb) {
            doSetProperty("verb", verb);
            return this;
        }
    
        /**
         * The FQCN of the class which implements io.dapr.workflows.Workflow.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param workflowClass the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder workflowClass(java.lang.String workflowClass) {
            doSetProperty("workflowClass", workflowClass);
            return this;
        }
    
        /**
         * The Dapr Workflow Client.
         * 
         * The option is a:
         * &lt;code&gt;io.dapr.workflows.client.DaprWorkflowClient&lt;/code&gt;
         * type.
         * 
         * Group: producer
         * 
         * @param workflowClient the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder workflowClient(io.dapr.workflows.client.DaprWorkflowClient workflowClient) {
            doSetProperty("workflowClient", workflowClient);
            return this;
        }
    
        /**
         * The instance ID of the workflow.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param workflowInstanceId the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder workflowInstanceId(java.lang.String workflowInstanceId) {
            doSetProperty("workflowInstanceId", workflowInstanceId);
            return this;
        }
    
        
        /**
         * The workflow operation to perform. Required for
         * DaprOperation.workflow operation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.dapr.WorkflowOperation&lt;/code&gt; type.
         * 
         * Default: scheduleNew
         * Group: producer
         * 
         * @param workflowOperation the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder workflowOperation(org.apache.camel.component.dapr.WorkflowOperation workflowOperation) {
            doSetProperty("workflowOperation", workflowOperation);
            return this;
        }
    
        /**
         * The start time of the new workflow.
         * 
         * The option is a: &lt;code&gt;java.time.Instant&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param workflowStartTime the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder workflowStartTime(java.time.Instant workflowStartTime) {
            doSetProperty("workflowStartTime", workflowStartTime);
            return this;
        }
    
        /**
         * The version of the workflow to start.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param workflowVersion the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder workflowVersion(java.lang.String workflowVersion) {
            doSetProperty("workflowVersion", workflowVersion);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }

    class DaprComponentBuilderImpl
            extends AbstractComponentBuilder<DaprComponent>
            implements DaprComponentBuilder {
        @Override
        protected DaprComponent buildConcreteComponent() {
            return new DaprComponent();
        }
        private org.apache.camel.component.dapr.DaprConfiguration getOrCreateConfiguration(DaprComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.dapr.DaprConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "client": getOrCreateConfiguration((DaprComponent) component).setClient((io.dapr.client.DaprClient) value); return true;
            case "configKeys": getOrCreateConfiguration((DaprComponent) component).setConfigKeys((java.lang.String) value); return true;
            case "configStore": getOrCreateConfiguration((DaprComponent) component).setConfigStore((java.lang.String) value); return true;
            case "configuration": ((DaprComponent) component).setConfiguration((org.apache.camel.component.dapr.DaprConfiguration) value); return true;
            case "contentType": getOrCreateConfiguration((DaprComponent) component).setContentType((java.lang.String) value); return true;
            case "previewClient": getOrCreateConfiguration((DaprComponent) component).setPreviewClient((io.dapr.client.DaprPreviewClient) value); return true;
            case "pubSubName": getOrCreateConfiguration((DaprComponent) component).setPubSubName((java.lang.String) value); return true;
            case "topic": getOrCreateConfiguration((DaprComponent) component).setTopic((java.lang.String) value); return true;
            case "bridgeErrorHandler": ((DaprComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "bindingName": getOrCreateConfiguration((DaprComponent) component).setBindingName((java.lang.String) value); return true;
            case "bindingOperation": getOrCreateConfiguration((DaprComponent) component).setBindingOperation((java.lang.String) value); return true;
            case "concurrency": getOrCreateConfiguration((DaprComponent) component).setConcurrency((io.dapr.client.domain.StateOptions.Concurrency) value); return true;
            case "consistency": getOrCreateConfiguration((DaprComponent) component).setConsistency((io.dapr.client.domain.StateOptions.Consistency) value); return true;
            case "eTag": getOrCreateConfiguration((DaprComponent) component).setETag((java.lang.String) value); return true;
            case "eventName": getOrCreateConfiguration((DaprComponent) component).setEventName((java.lang.String) value); return true;
            case "expiryInSeconds": getOrCreateConfiguration((DaprComponent) component).setExpiryInSeconds((java.lang.Integer) value); return true;
            case "getWorkflowIO": getOrCreateConfiguration((DaprComponent) component).setGetWorkflowIO((boolean) value); return true;
            case "httpExtension": getOrCreateConfiguration((DaprComponent) component).setHttpExtension((io.dapr.client.domain.HttpExtension) value); return true;
            case "key": getOrCreateConfiguration((DaprComponent) component).setKey((java.lang.String) value); return true;
            case "lazyStartProducer": ((DaprComponent) component).setLazyStartProducer((boolean) value); return true;
            case "lockOperation": getOrCreateConfiguration((DaprComponent) component).setLockOperation((org.apache.camel.component.dapr.LockOperation) value); return true;
            case "lockOwner": getOrCreateConfiguration((DaprComponent) component).setLockOwner((java.lang.String) value); return true;
            case "methodToInvoke": getOrCreateConfiguration((DaprComponent) component).setMethodToInvoke((java.lang.String) value); return true;
            case "reason": getOrCreateConfiguration((DaprComponent) component).setReason((java.lang.String) value); return true;
            case "resourceId": getOrCreateConfiguration((DaprComponent) component).setResourceId((java.lang.String) value); return true;
            case "secretStore": getOrCreateConfiguration((DaprComponent) component).setSecretStore((java.lang.String) value); return true;
            case "serviceToInvoke": getOrCreateConfiguration((DaprComponent) component).setServiceToInvoke((java.lang.String) value); return true;
            case "stateOperation": getOrCreateConfiguration((DaprComponent) component).setStateOperation((org.apache.camel.component.dapr.StateOperation) value); return true;
            case "stateStore": getOrCreateConfiguration((DaprComponent) component).setStateStore((java.lang.String) value); return true;
            case "storeName": getOrCreateConfiguration((DaprComponent) component).setStoreName((java.lang.String) value); return true;
            case "timeout": getOrCreateConfiguration((DaprComponent) component).setTimeout((java.time.Duration) value); return true;
            case "verb": getOrCreateConfiguration((DaprComponent) component).setVerb((java.lang.String) value); return true;
            case "workflowClass": getOrCreateConfiguration((DaprComponent) component).setWorkflowClass((java.lang.String) value); return true;
            case "workflowClient": getOrCreateConfiguration((DaprComponent) component).setWorkflowClient((io.dapr.workflows.client.DaprWorkflowClient) value); return true;
            case "workflowInstanceId": getOrCreateConfiguration((DaprComponent) component).setWorkflowInstanceId((java.lang.String) value); return true;
            case "workflowOperation": getOrCreateConfiguration((DaprComponent) component).setWorkflowOperation((org.apache.camel.component.dapr.WorkflowOperation) value); return true;
            case "workflowStartTime": getOrCreateConfiguration((DaprComponent) component).setWorkflowStartTime((java.time.Instant) value); return true;
            case "workflowVersion": getOrCreateConfiguration((DaprComponent) component).setWorkflowVersion((java.lang.String) value); return true;
            case "autowiredEnabled": ((DaprComponent) component).setAutowiredEnabled((boolean) value); return true;
            default: return false;
            }
        }
    }
}