/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import java.util.function.Supplier;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.annotations.StatsDoc;

@StatsDoc(name="bookie", category="server", help="Ledger metadata index stats")
class LedgerMetadataIndexStats {
    private static final String LEDGERS_COUNT = "ledgers-count";
    @StatsDoc(name="ledgers-count", help="Current number of ledgers")
    private final Gauge<Long> ledgersCountGauge;

    LedgerMetadataIndexStats(StatsLogger statsLogger, final Supplier<Long> ledgersCountSupplier) {
        this.ledgersCountGauge = new Gauge<Long>(){

            public Long getDefaultValue() {
                return 0L;
            }

            public Long getSample() {
                return (Long)ledgersCountSupplier.get();
            }
        };
        statsLogger.registerGauge(LEDGERS_COUNT, this.ledgersCountGauge);
    }

    public Gauge<Long> getLedgersCountGauge() {
        return this.ledgersCountGauge;
    }
}

