/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.Progressable;

public abstract class TaskInputOutputContext<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends TaskAttemptContext
implements Progressable {
    private RecordWriter<KEYOUT, VALUEOUT> output;
    private StatusReporter reporter;
    private OutputCommitter committer;

    public TaskInputOutputContext(Configuration conf, TaskAttemptID taskid, RecordWriter<KEYOUT, VALUEOUT> output, OutputCommitter committer, StatusReporter reporter) {
        super(conf, taskid);
        this.output = output;
        this.reporter = reporter;
        this.committer = committer;
    }

    public abstract boolean nextKeyValue() throws IOException, InterruptedException;

    public abstract KEYIN getCurrentKey() throws IOException, InterruptedException;

    public abstract VALUEIN getCurrentValue() throws IOException, InterruptedException;

    public void write(KEYOUT key, VALUEOUT value) throws IOException, InterruptedException {
        this.output.write(key, value);
    }

    public Counter getCounter(Enum<?> counterName) {
        return this.reporter.getCounter(counterName);
    }

    public Counter getCounter(String groupName, String counterName) {
        return this.reporter.getCounter(groupName, counterName);
    }

    @Override
    public void progress() {
        this.reporter.progress();
    }

    public float getProgress() {
        return this.reporter.getProgress();
    }

    @Override
    public void setStatus(String status) {
        this.reporter.setStatus(status);
    }

    public OutputCommitter getOutputCommitter() {
        return this.committer;
    }
}

