
                incdir  "include:"
                include "exec/execbase.i"
                include "exec/initializers.i"
                include "exec/memory.i"
                include "dos/dos.i"
                include "dos/dosextens.i"
                include "devices/input.i"
                include "devices/inputevent.i"
                include "intuition/intuition.i"
                include "workbench/workbench.i"
                include "lvo/LVOs.i"            ; my collection of LVOs

_LVOPrivateOpenLibrary  EQU -$32A               ; _LVOexecPrivate17
                                                ; gfxbase   D0 =  1
                                                ; layerbase D0 =  2
                                                ; intuibase D0 =  3
                                                ; dosbase   D0 =  4
                                                ; iconbase  D0 =  5
                                                ; expanbase D0 =  6
                                                ; utilbase  D0 =  7
                                                ; keymap    D0 =  8
                                                ; gadtools  D0 =  9
                                                ; wbbase    D0 = 10

RefreshIcons    MOVEA.L (4).w,A6                ; 2024 by Peter Keunecke
                MOVEA.L ThisTask(A6),A0
                LEA     pr_MsgPort(A0),A5
                TST.L   pr_CLI(A0)              ; from CLI or WB ?
                BNE.S   .openlibrary
                MOVEA.L A5,A0                   ; pr_MsgPort
                JSR     _LVOWaitPort(A6)        ; wait for startup
                MOVE.L  D0,-(SP)                ; save WB message
                MOVEA.L A5,A0                   ; pr_MsgPort
                JSR     _LVOGetMsg(A6)          ; remove Msg from port
                PEA     .replyWBmsg(PC)         ; WB patch for RTS from CLI calls
.openlibrary    MOVEQ   #RETURN_ERROR,D2
                MOVEQ   #3,D0
                JSR     _LVOPrivateOpenLibrary(A6)
                MOVE.L  D0,D6                   ; intuibase
                BEQ.W   .openerror
                MOVE.L  D6,-(SP)
                LEA     WBPubScreenName(PC),A0  ; "Workbench"
                MOVEA.L D6,A6                   ; intuibase
                JSR     _LVOLockPubScreen(A6)
                TST.L   D0
                BEQ.W   .notlocked
                MOVE.L  D0,-(SP)
                MOVEQ   #0,D0                   ; LockNumber
                JSR     _LVOLockIBase(A6)
                MOVE.L  D0,D7
                MOVEA.L (SP),A0                 ; WB screen
                MOVE.L  sc_FirstWindow(A0),D0
.trywindow      BEQ.S   .returnnow
                MOVEA.L D0,A2
                BTST.B  #(25-24),wd_Flags(A2)
                BNE.S   .windowptr              ; bit 25 means WFG_WBENCHWINDOW
                MOVE.L  (A2),D0                 ; wd_NextWindow
                BRA.S   .trywindow

.returnnow      MOVEA.L D7,A0                   ; lock on IBase
                JSR     _LVOUnlockIBase(A6)
                BRA.W   .unlockpub

.windowptr      BTST.B  #(13-8),wd_IDCMPFlags+2(A2)
                BNE.S   .returnnow              ; bit 13 means IDCMP_MENUVERIFY
                MOVE.L  wd_MenuStrip(A2),D0     ; first menu in WB menu strip
                BEQ.S   .returnnow
                MOVEA.L D0,A3                   ; A3 = menu strip = menu 0
                MOVE.L  mu_FirstItem(A3),D0     ; item 0 ?
                BEQ.S   .returnnow
                MOVEQ   #3,D1
.nextitem       MOVEA.L D0,A4                   ; item 0 - 3
                MOVE.L  (A4),D0                 ; next ?
                BEQ.S   .returnnow
                DBRA    D1,.nextitem            ; A4 = item 3 should be "Update All"
                MOVEA.L D0,A0                   ; item 4
                MOVE.L  (A0),D0                 ; item 5 ?
                BEQ.S   .returnnow
                MOVEA.L D0,A0                   ; is item 5 "Version, Copyright ..."
                CMPI.B  #"?",mi_Command(A0)     ; with the "?" as a shortcut key ?
                BNE.S   .returnnow              ; if not, we won't touch this menu
                LEA     MsgMenuRescanAll\.im_IDCMPWindow(PC),A0
                MOVE.L  A2,(A0)                 ; IDCMPWindow = Workbench Window
                MOVEA.L (4).w,A6                ; execbase
                JSR     _LVOForbid(A6)
                MOVEA.L D7,A0                   ; lock on IBase
                MOVEA.L D6,A6                   ; intuibase
                JSR     _LVOUnlockIBase(A6)
                MOVEA.L A2,A0                   ; WB window
                JSR     _LVOClearMenuStrip(A6)
                ORI.W   #MENUENABLED,mu_Flags(A3)
                ORI.W   #ITEMENABLED,mi_Flags(A4)
                MOVE.W  #MENUNULL,mi_NextSelect(A4) ; this is set to NULL by the OS
                MOVEA.L A2,A0                   ; WB window
                MOVEA.L A3,A1                   ; menu strip
                JSR     _LVOSetMenuStrip(A6)
                MOVEA.L A2,A0                   ; WB window
                JSR     _LVOActivateWindow(A6)
                LEA     MsgMenuRescanAll\.mn_ReplyPort(PC),A0
                MOVE.L  A5,(A0)                 ; pr_MsgPort
                MOVEA.L wd_UserPort(A2),A0      ; IDCMP receiver for Workbench
                LEA     MsgMenuRescanAll(PC),A1 ; message: MENUPICK, MENU_RESCAN_ALL
                MOVEA.L (4).w,A6                ; execbase
                JSR     _LVOPutMsg(A6)
                JSR     _LVOPermit(A6)
                MOVEA.L A5,A0                   ; pr_MsgPort
                JSR     _LVOWaitPort(A6)        ; wait for reply from Workbench
                MOVEA.L A5,A0                   ; pr_MsgPort
                JSR     _LVOGetMsg(A6)          ; remove Msg, "Update All" is done !
                MOVEQ   #4,D0                   ; refresh disks and left out icons
                JSR     _LVOPrivateOpenLibrary(A6)
                MOVE.L  D0,D4                   ; dosbase
                BEQ.W   .unlockpub              ; really ?
                MOVEQ   #5,D0
                JSR     _LVOPrivateOpenLibrary(A6)
                TST.L   D0                      ; iconbase ?
                BEQ.S   .openwblib
                MOVEA.L D0,A6                   ; iconbase
                LEA     deficon_RAM(PC),A0      ; DefIcons caches the wrong colors !
                JSR     _LVOGetDiskObject(A6)   ; let's recognize the new screenmode
                BNE.S   .putramicon
                LEA     RamDiskIcon(PC),A0      ; and Ram Disk won't support INHIBIT
                JSR     _LVOGetDiskObjectNew(A6)
.putramicon     LEA     RamDiskIcon(PC),A0      ; in case that no disk.info exists
                MOVEA.L D0,A1
                JSR     _LVOPutDiskObject(A6)   ; write the deficon to RAM:disk.info
                MOVEA.L A6,A1                   ; iconbase
                MOVEA.L (4).w,A6                ; execbase
                JSR     _LVOCloseLibrary(A6)
.openwblib      MOVEQ   #10,D0
                JSR     _LVOPrivateOpenLibrary(A6)
                MOVE.L  D0,D5                   ; wbbase
                BEQ.W   .wbfailure
                MOVE.L  SP,D6                   ; points below the 1024 bytes table
                LEA     -1024(SP),SP            ; reserves two longs for 128 objects
                MOVEA.L SP,A5                   ; table:  object names, parent-locks
                MOVEA.L D4,A6                   ; dosbase
                MOVEA.L D5,A0                   ; wbbase
                MOVEQ   #40,D0
                SUB.W   LIB_VERSION(A0),D0
                BCS.S   .getvolumes             ; WB > v40 may have a newer structure
                SUBQ.L  #1,D0
                BHI.S   .getvolumes             ; WB < v39 has a different structure
                LEA     $F4(A0),A4              ; wb_MasterList
                MOVE.L  $19C(A0),D7             ; wb_RootObject
.nextobject     MOVEA.L (A4),A4                 ; current WBObject
                TST.L   (A4)                    ; is this lh_Tail = NULL ? 
                BEQ.S   .oldobjects
                CMPA.L  D7,A4                   ; is this object the root ?
                BEQ.S   .nextobject
                MOVE.L  $38(A4),D0              ; wo_Parent ?
                BEQ.S   .nextobject
                MOVEA.L D0,A0
                TST.L   $86(A0)                 ; Parent/wo_DrawerSilent flag bit 31?
                BMI.S   .getdirlock
                MOVE.L  $48(A4),D1              ; wo_DrawerData ?
                BEQ.S   .nextobject
                MOVEA.L D1,A1                   ; object drawer data
                TST.L   $1AA(A1)                ; dd_DrawerWin ?
                BEQ.S   .nextobject
.getdirlock     MOVE.L  $48(A0),D0              ; Parent/wo_DrawerData ?
                BEQ.S   .nextobject
                MOVE.L  $8C(A4),(A5)            ; wo_Name ?
                BEQ.S   .nextobject
                ADDQ.W  #4,A5
                MOVEA.L D0,A0                   ; parent drawer data
                MOVE.L  $1C0(A0),(A5)+          ; dd_Lock on parent directory
                CMPA.L  D6,A5                   ; are we below our table bottom ?
                BCS.S   .nextobject
.oldobjects     CMPA.L  SP,A5                   ; any old objects in the table ?
                BEQ.S   .getvolumes
                MOVE.L  A5,D6                   ; actual end of the object table
                MOVEA.L SP,A5                   ; back to the top of our table
                MOVEA.L D5,A6                   ; wbbase
.drawobject     MOVEM.L (A5)+,A0-A1             ; object name and parent-lock
                MOVEQ   #UPDATEWB_ObjectAdded,D0
                JSR     _LVOUpdateWorkbench(A6)
                CMPA.L  D6,A5
                BCS.S   .drawobject
                MOVEA.L D4,A6                   ; dosbase
                MOVEA.L SP,A5                   ; stack for 85 volumes * 3 longs + 1
.getvolumes     MOVEQ   #(LDF_VOLUMES|LDF_READ),D1
                JSR     _LVOLockDosList(A6)     ; MsgPorts,filehandles,volume-locks
                MOVE.L  D0,-(SP)                ; dlist header
.nextvolume     MOVE.L  (SP),D1                 ; dlist
                MOVEQ   #(LDF_VOLUMES|LDF_READ),D2
                JSR     _LVONextDosEntry(A6)
                MOVE.L  D0,(SP)                 ; new dlist entry
                BEQ.S   .endoftable
                MOVEA.L (SP),A0                 ; dlist entry
                MOVE.L  dol_Task(A0),(A5)+      ; Msg_Port of the handler task
                MOVEA.L dol_Name(A0),A0         ; BSTR volume name BCPL string
                ADDA.L  A0,A0
                ADDA.L  A0,A0                   ; BPTR -> APTR
                ADDQ.W  #1,A0                   ; skip the byte for string length
                SUBA.L  A3,A3                   ; no ".backdrop" filehandle yet
                MOVEQ   #0,D7                   ; a volume entry, not updated yet
                BSR.W   .updatingicon           ; sets D6 = lock, A3 = filehandle
                TST.L   D7                      ; no disk.info = 0, has disk.info = -1
                BEQ.S   .nodiskinfo
                MOVE.L  D7,-4(A5)               ; disk.info exists and can be updated
.nodiskinfo     MOVE.L  A3,(A5)+                ; filehandle of ".backdrop" or NULL
                MOVE.L  D6,(A5)+                ; was a lock on "volume:" successful ?
                BNE.S   .goodvolume
                SUBQ.W  #8,A5
                MOVE.L  A3,D1                   ; .backdrop filehandle or NULL
                BEQ.S   .skipvolume
                JSR     _LVOClose(A6)
.skipvolume     CLR.L   -(A5)                   ; no lock, don't use this "volume:"
.goodvolume     LEA     1020+4(SP),A0
                CMPA.L  A0,A5                   ; avoid stack trashing below table
                BCS.S   .nextvolume
.endoftable     CLR.L   (A5)                    ; put NULL at the end of the table
                MOVEQ   #(LDF_VOLUMES|LDF_READ),D1
                JSR     _LVOUnLockDosList(A6)
                ADDQ.W  #4,SP                   ; drop off dlist
                MOVEQ   #10,D1
                JSR     _LVODelay(A6)
                MOVEA.L SP,A5                   ; back to the top of the table
.nextupdate     MOVE.L  (A5)+,D7                ; MsgPort, NULL=end or -1=disk.info ?
                BEQ.W   .updatedone
                MOVEA.L (A5)+,A3                ; filehandle of ".backdrop" or NULL
                MOVE.L  (A5)+,D6                ; lock on "volume:"
                MOVE.L  D6,D1
                JSR     _LVOCurrentDir(A6)
                MOVEM.L D0/D6/A3,-(SP)          ; oldlock, volume lock, filehandle
                MOVE.L  D7,D6                   ; -1 means disk.info was found
                BPL.S   .tryleftout             ; it's a volume MsgPort
                LEA     string_disk(PC),A0
                BSR.W   .updatingicon           ; refresh the "disk.info" icon
.tryleftout     MOVE.L  A3,D1                   ; .backdrop filehandle
                BEQ.S   .currentdir
                MOVEQ   #0,D2                   ; offset position
                MOVEQ   #OFFSET_END,D3
                JSR     _LVOSeek(A6)
                MOVE.L  A3,D1                   ; .backdrop filehandle
                MOVEQ   #OFFSET_BEGINNING,D3
                JSR     _LVOSeek(A6)
                MOVE.L  D0,D3                   ; old position = size of file
                BLE.S   .currentdir
                ADDQ.L  #1,D0                   ; if last char is not a NewLine
                MOVEQ   #MEMF_PUBLIC,D1
                MOVEA.L (4).w,A6                ; execbase
                JSR     _LVOAllocVec(A6)
                MOVEA.L D4,A6                   ; dosbase
                MOVE.L  D0,D2                   ; buffer for copy of ".backdrop"
                BEQ.S   .currentdir
                MOVE.L  D0,-(SP)                ; start of copy buffer
                MOVE.L  A3,D1                   ; .backdrop filehandle
                JSR     _LVORead(A6)            ; D3 = size of file ".backdrop"
                CMP.L   D0,D3                   ; all bytes read ?
                BNE.S   .freebuffer
                MOVEM.L D2-D3,-(SP)             ; buffer position, size of file
.nextstring     MOVEA.L (SP),A0                 ; current string position
                MOVEM.L 4(SP),D0-D1             ; file size and start of buffer
                ADD.L   D0,D1                   ; start + file size = last byte
                SUB.L   A0,D1                   ; - position = remaining bytes
                BLS.S   .allupdated
                MOVEA.L A0,A1                   ; beginning of the new string
                SUBQ.L  #1,D1                   ; - 1 passes for DBEQ loop
                MOVEQ   #$A,D7                  ; find NewLine character D7=$A
.getnewline     CMP.B   (A1)+,D7
                DBEQ    D1,.getnewline
                BNE.S   .laststring             ; no $A at the end of the file
                MOVE.L  A1,(SP)                 ; next string position after $A
                CLR.B   -(A1)                   ; terminate the string at $A
                BSR.W   .backdropicon           ; D7 not zero, preserves D6, A3
                BRA.S   .nextstring

.laststring     CLR.B   (A1)                    ; terminate the last string
                BSR.W   .backdropicon           ; D7 not zero
.allupdated     ADDQ.W  #8,SP                   ; drop buffer position and size
.freebuffer     MOVEA.L (SP)+,A1
                MOVEA.L (4).w,A6                ; execbase
                JSR     _LVOFreeVec(A6)
                MOVEA.L D4,A6                   ; dosbase
.currentdir     MOVEM.L (SP)+,D1-D2/A3          ; oldlock, volume lock, filehandle
                JSR     _LVOCurrentDir(A6)
                MOVE.L  A3,D1                   ; .backdrop filehandle
                BEQ.S   .volumedone
                JSR     _LVOClose(A6)
.volumedone     TST.L   D6                      ; D6 = -1 if disk.info was updated
                BPL.W   .nextupdate             ; volume stays locked until inhibit
                MOVE.L  D2,D1                   ; lock on "volume:"
                JSR     _LVOUnLock(A6)
                BRA.W   .nextupdate

.updatedone     MOVE.L  1024+4(SP),D6           ; intuibase
                MOVEA.L (4).w,A6                ; execbase
                JSR     _LVOForbid(A6)
                LEA     .norequests(PC),A0      ; disable EasyRequestArgs() pop-ups
                MOVE.L  A0,D0                   ; patch it with a new dummy function
                MOVEA.W #_LVOEasyRequestArgs,A0 ; used by AutoUpdateWB for example
                MOVEA.L D6,A1                   ; intuibase
                JSR     _LVOSetFunction(A6)
                MOVEA.L D0,A3                   ; backup the old function
                JSR     _LVOPermit(A6)
                MOVEA.L D4,A6                   ; dosbase
                MOVEA.L SP,A5                   ; back to the top of the volume table
.diskchange     MOVE.L  (A5)+,D7                ; pr_MsgPort of the handler or end ?
                BEQ.S   .alldonenow
                BPL.S   .hasmsgport
                ADDQ.W  #8,A5                   ; disk.info exists, fh closed, unlocked
                BRA.S   .diskchange

.norequests     MOVEQ   #0,D0                   ; pretend that the user selects "Cancel"
                RTS

.hasmsgport     MOVE.L  D7,D1                   ; pr_MsgPort of the handler
                MOVEQ   #31,D2                  ; action = 31 = ACTION_INHIBIT
                MOVEQ   #-1,D3                  ; arg1   = -1 = DOSTRUE = disk blocked
                JSR     _LVODoPkt(A6)
                MOVEA.L D0,D3
                ADDQ.W  #4,A5                   ; skip over filehandle
                MOVE.L  (A5)+,D1                ; lock on "volume:"
                JSR     _LVOUnLock(A6)
                TST.L   D3                      ; was this packet executed ?
                BEQ.S   .diskchange
                MOVEA.L (4).w,A0                ; execbase
                MOVEA.L ThisTask(A0),A0
                MOVEA.L pr_WindowPtr(A0),A4
                MOVEQ   #-1,D0
                MOVE.L  D0,pr_WindowPtr(A0)     ; no requesters: "Insert DFx:" wanted
                MOVEQ   #4-1,D3
                LEA     FloppyDisks(PC),A2
.floppytest     MOVE.L  A2,D1
                JSR     _LVODeviceProc(A6)
                CMP.L   D7,D0                   ; is this the handler MsgPort of DFx: ?
                BEQ.S   .waitawhile
                ADDQ.W  #5,A2                   ; skip to next "DFx:",0 in FloppyDisks
                DBRA    D3,.floppytest
                MOVEQ   #50,D1                  ; wait one second for some slow disks
                BRA.S   .changedisk

.waitawhile     MOVEQ   #127,D1
                ADD.L   D1,D1                   ; wait 5 seconds for the slow floppies
.changedisk     JSR     _LVODelay(A6)
                MOVE.L  D7,D1                   ; pr_MsgPort of a handler again
                MOVEQ   #0,D3                   ; arg1 = 0 = DOSFALSE = disk changed
                JSR     _LVODoPkt(A6)
                MOVEA.L (4).w,A0                ; execbase
                MOVEA.L ThisTask(A0),A0
                MOVE.L  A4,pr_WindowPtr(A0)     ; allow requesters again as before
                BRA.S   .diskchange

.alldonenow     MOVEA.L (4).w,A6                ; execbase
                JSR     _LVOForbid(A6)
                MOVEA.W #_LVOEasyRequestArgs,A0
                MOVEA.L D6,A1                   ; intuibase
                MOVE.L  A3,D0                   ; restore the original function
                JSR     _LVOSetFunction(A6)
                JSR     _LVOPermit(A6)
                LEA     1024(SP),SP             ; drop off the pointer table
                MOVEQ   #RETURN_OK,D2
                MOVEA.L D5,A1                   ; wbbase
                JSR     _LVOCloseLibrary(A6)
.wbfailure      MOVEA.L D4,A1                   ; dosbase
                JSR     _LVOCloseLibrary(A6)
.unlockpub      SUBA.L  A0,A0                   ; no screen name supplied
                MOVEA.L (SP)+,A1                ; WB screen from lock
                MOVEA.L (SP),A6                 ; intuibase
                JSR     _LVOUnlockPubScreen(A6)
.notlocked      MOVEA.L (SP)+,A1                ; intuibase
                MOVEA.L (4).w,A6                ; execbase
                JSR     _LVOCloseLibrary(A6)
.openerror      MOVE.L  D2,D0
                RTS                             ; CLI ends here, on WB to .replyWBmsg

.replyWBmsg     JSR     _LVOForbid(A6)
                MOVEA.L (SP)+,A1
                JSR     _LVOReplyMsg(A6)        ; WB unloads seglist
                MOVE.L  D2,D0                   ; set the final RC
.stringtoolong  RTS     ;------------------------ return from WB tool or backdropicon


.backdropicon   SUBA.L  A0,A1                   ; two subroutine entries
                SUBA.W  #255,A1                 ; for UpdateWorkbench()
                BHI.S   .stringtoolong
.updatingicon   LEA     -268(SP),SP             ; extended name string
                MOVEA.L SP,A1                   ; max 255+12 chars + $0
.copyfilename   MOVE.B  (A0)+,(A1)+
                BNE.S   .copyfilename
                SUBQ.W  #2,A1
                CMPI.B  #"/",(A1)               ; dir name with slash ?
                BEQ.S   .append_.info           ; cut off the dir slash
                CMPI.B  #":",(A1)+              ; disk name with ":" ?
                BEQ.S   .append_disk
                TST.L   D7                      ; is it a volume name ?
                BNE.S   .append_.info
                MOVE.B  #":",(A1)+              ; append ":"
                MOVEA.L A1,A4
                CLR.B   (A1)                    ; terminate volume name
                MOVE.L  SP,D1                   ; "volume:",0
                MOVEQ   #ACCESS_READ,D2
                JSR     _LVOLock(A6)
                MOVE.L  D0,D6                   ; lock on "volume:"
                BEQ.W   .updatefailed
                LEA     string.backdrop(PC),A0
                MOVEA.L A4,A1
                MOVEQ   #9,D0
.add_.backdrop  MOVE.B  (A0)+,(A1)+             ; append ".backdrop",0
                DBRA    D0,.add_.backdrop
                MOVE.L  SP,D1                   ; "volume:.backdrop",0
                MOVE.L  #MODE_OLDFILE,D2
                JSR     _LVOOpen(A6)
                MOVEA.L D0,A3                   ; filehandle or NULL
                MOVEA.L A4,A1
.append_disk    LEA     string_disk(PC),A0
                MOVEQ   #4-1,D0
.add_disk       MOVE.B  (A0)+,(A1)+             ; append "disk"
                DBRA    D0,.add_disk
.append_.info   MOVEA.L A1,A4                   ; position of ".info"
                LEA     string.info(PC),A0
                MOVEQ   #5,D0
.add_.info      MOVE.B  (A0)+,(A1)+             ; append ".info",0
                DBRA    D0,.add_.info
                MOVE.L  SP,D1                   ; icon name.info
                MOVEQ   #ACCESS_READ,D2
                JSR     _LVOLock(A6)
                MOVE.L  D0,D1                   ; lock on name.info ?
                BEQ.S   .updatefailed
                JSR     _LVOUnLock(A6)
                TST.L   D7                      ; is it a volume name ?
                BEQ.S   .volumelocked
                MOVE.L  SP,D1                   ; icon name memblock
                JSR     _LVOPathPart(A6)
                MOVEA.L D0,A2                   ; end of path + 1
                MOVE.B  (A2),D3                 ; backup one character
                CLR.B   (A2)                    ; terminate path part
                MOVE.L  SP,D1                   ; root:path only now
                JSR     _LVOLock(A6)
                MOVE.L  SP,D1                   ; icon name
                MOVE.L  D0,D2                   ; path lock
                MOVE.B  D3,(A2)                 ; restore one character
                CLR.B   (A4)                    ; cut off ".info"
                JSR     _LVOFilePart(A6)
                MOVEA.L D0,A0                   ; name file part
                MOVEA.L D2,A1                   ; parent lock
                MOVEQ   #UPDATEWB_ObjectAdded,D0
                TST.L   D6                      ; was there a disk.info = -1 ?
                BMI.S   .updateobject
                MOVEQ   #UPDATEWB_ObjectRemoved,D0 ; remove icons for DiskChange
.updateobject   MOVEA.L D5,A6                   ; wbbase
                JSR     _LVOUpdateWorkbench(A6)
                MOVE.L  D2,D1                   ; parent lock
                MOVEA.L D4,A6                   ; dosbase
                JSR     _LVOUnLock(A6)
.volumelocked   MOVEQ   #-1,D7                  ; -1 for a real disk.info file
.updatefailed   LEA     268(SP),SP              ; drop the name string buffer
                RTS

MENU_RESCAN_ALL EQU	(0 & $1F) | ((3 & $3F) << 5) | (($1F & $1F) << 11)

MsgMenuRescanAll
.ln_Succ        DC.L    0
.ln_Pred        DC.L    0
.ln_Type        DC.B    0
.ln_Pri         DC.B    0
.ln_Name        DC.L    0
.mn_ReplyPort   DC.L    0                       ; filled out at program start
.mn_Length      DC.W    $34
.im_Class       DC.L    IDCMP_MENUPICK
.im_Code        DC.W    MENU_RESCAN_ALL         ; Menu 0, Item 3, NoSub
.im_Qualifier   DC.W    0
.im_IAddress    DC.L    0
.im_MouseX      DC.W    0
.im_MouseY      DC.W    0
.im_Seconds     DC.L    0
.im_Micros      DC.L    0
.im_IDCMPWindow DC.L    0                       ; a WBENCHWINDOW
.im_SpecialLink DC.L    0

                DC.B    "$VER: RefreshIcons 1.3",0

WBPubScreenName DC.B    "Workbench",0

FloppyDisks     DC.B    "DF0:",0,"DF1:",0,"DF2:",0,"DF3",0

deficon_RAM     DC.B    "Env:Sys/def_RAM",0

RamDiskIcon     DC.B    "RAM:"
string_disk     DC.B    "disk",0

string.info     DC.B    ".info",0

string.backdrop DC.B    ".backdrop",0

                CNOP    0,4

