/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.eval.other;

import java.util.Objects;
import org.eclipse.wb.tests.designer.core.eval.AbstractEngineTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ArrayTest
extends AbstractEngineTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            ArrayTest.do_projectCreate();
        }
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_array_int_1() throws Exception {
        this.check_array(new int[]{1, 2, 3}, "new int[]{1, 2, 3}", "int[]");
    }

    @Test
    public void test_array_int_2_1() throws Exception {
        this.check_array(new int[][]{{11, 12}, {21, 22}, {31, 32}}, "new int[][]{new int[]{11, 12}, new int[]{21, 22}, new int[]{31, 32}}", "int[][]");
    }

    @Test
    public void test_array_int_2_2() throws Exception {
        this.check_array(new int[][]{{11, 12}, {21, 22}, {31, 32}}, "new int[][]{{11, 12}, {21, 22}, {31, 32}}", "int[][]");
    }

    @Test
    public void test_array_boolean() throws Exception {
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[2] = true;
        this.check_array(blArray, "new boolean[]{true, false, true}", "boolean[]");
    }

    @Test
    public void test_array_byte() throws Exception {
        this.check_array(new byte[]{1, 2, 3}, "new byte[]{1, 2, 3}", "byte[]");
    }

    @Test
    public void test_array_short() throws Exception {
        this.check_array(new short[]{1, 2, 3}, "new short[]{1, 2, 3}", "short[]");
    }

    @Test
    public void test_array_char() throws Exception {
        this.check_array(new char[]{'a', 'b', 'c'}, "new char[]{'a', 'b', 'c'}", "char[]");
    }

    @Test
    public void test_array_char2() throws Exception {
        this.check_array(new char[]{'0', '1', '2'}, "new char[]{0x30, 0x31, 0x32}", "char[]");
    }

    @Test
    public void test_array_long() throws Exception {
        this.check_array(new long[]{1L, 2L, 3L}, "new long[]{1, 2, 3}", "long[]");
    }

    @Test
    public void test_array_float() throws Exception {
        this.check_array(new float[]{1.0f, 2.0f, 3.0f}, "new float[]{1, 2, 3}", "float[]");
    }

    @Test
    public void test_array_double() throws Exception {
        this.check_array(new double[]{1.0, 2.0, 3.0}, "new double[]{1, 2, 3}", "double[]");
    }

    @Test
    public void test_array_String_1() throws Exception {
        this.check_array(new String[]{"1", "2", "3"}, "new String[]{\"1\", \"2\", \"3\"}", "java.lang.String[]");
    }

    @Test
    public void test_array_String_2() throws Exception {
        this.check_array(new String[][]{{"11", "12"}, {"21", "22"}, {"31", "32"}}, "new String[][]{{\"11\", \"12\"}, {\"21\", \"22\"}, {\"31\", \"32\"}}", "java.lang.String[][]");
    }

    @Test
    public void test_array_String_empty_1() throws Exception {
        this.check_array(new String[2], "new String[2]", "java.lang.String[]");
    }

    @Test
    public void test_array_String_empty_2() throws Exception {
        this.check_array(new String[2][3], "new String[2][3]", "java.lang.String[][]");
    }

    @Test
    public void test_arrayElement_1() throws Exception {
        ArrayTest.assertEquals((Object)11, (Object)this.evaluateExpression("(new int[]{0, 11, 22})[1]", "int"));
    }

    private void check_array(Object expected, String expression, String returnType) throws Exception {
        ArrayTest.assertTrue((boolean)Objects.deepEquals(expected, this.evaluateExpression(expression, returnType)));
    }
}

